<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendApplicationResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendApplicationResponse $parameters
     * @return \StructType\SendApplicationResponseResponse|bool
     */
    public function SendApplicationResponse(\StructType\SendApplicationResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendApplicationResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendMailQueueAgainResponse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendMailQueueAgainResponse $parameters
     * @return \StructType\SendMailQueueAgainResponseResponse|bool
     */
    public function SendMailQueueAgainResponse(\StructType\SendMailQueueAgainResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendMailQueueAgainResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceData $parameters
     * @return \StructType\SendInvoiceDataResponse|bool
     */
    public function SendInvoiceData(\StructType\SendInvoiceData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoiceData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendEArchiveData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendEArchiveData $parameters
     * @return \StructType\SendEArchiveDataResponse|bool
     */
    public function SendEArchiveData(\StructType\SendEArchiveData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendEArchiveData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendBase64StringEArchiveData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendBase64StringEArchiveData $parameters
     * @return \StructType\SendBase64StringEArchiveDataResponse|bool
     */
    public function SendBase64StringEArchiveData(\StructType\SendBase64StringEArchiveData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBase64StringEArchiveData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceDataWithTemplateCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceDataWithTemplateCode $parameters
     * @return \StructType\SendInvoiceDataWithTemplateCodeResponse|bool
     */
    public function SendInvoiceDataWithTemplateCode(\StructType\SendInvoiceDataWithTemplateCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoiceDataWithTemplateCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendEArchiveDataWithTemplateCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendEArchiveDataWithTemplateCode $parameters
     * @return \StructType\SendEArchiveDataWithTemplateCodeResponse|bool
     */
    public function SendEArchiveDataWithTemplateCode(\StructType\SendEArchiveDataWithTemplateCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendEArchiveDataWithTemplateCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SendBase64StringEArchiveDataWithTemplateCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendBase64StringEArchiveDataWithTemplateCode $parameters
     * @return \StructType\SendBase64StringEArchiveDataWithTemplateCodeResponse|bool
     */
    public function SendBase64StringEArchiveDataWithTemplateCode(\StructType\SendBase64StringEArchiveDataWithTemplateCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBase64StringEArchiveDataWithTemplateCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendBase64StringInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendBase64StringInvoice $parameters
     * @return \StructType\SendBase64StringInvoiceResponse|bool
     */
    public function SendBase64StringInvoice(\StructType\SendBase64StringInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBase64StringInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SendBase64StringInvoiceWithTemplateCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendBase64StringInvoiceWithTemplateCode $parameters
     * @return \StructType\SendBase64StringInvoiceWithTemplateCodeResponse|bool
     */
    public function SendBase64StringInvoiceWithTemplateCode(\StructType\SendBase64StringInvoiceWithTemplateCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBase64StringInvoiceWithTemplateCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendXmlInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendXmlInvoice $parameters
     * @return \StructType\SendXmlInvoiceResponse|bool
     */
    public function SendXmlInvoice(\StructType\SendXmlInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendXmlInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendUBLInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendUBLInvoice $parameters
     * @return \StructType\SendUBLInvoiceResponse|bool
     */
    public function SendUBLInvoice(\StructType\SendUBLInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendUBLInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCumulativeInvoiceData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendCumulativeInvoiceData $parameters
     * @return \StructType\SendCumulativeInvoiceDataResponse|bool
     */
    public function SendCumulativeInvoiceData(\StructType\SendCumulativeInvoiceData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCumulativeInvoiceData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendInvoiceAsEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendInvoiceAsEmail $parameters
     * @return \StructType\SendInvoiceAsEmailResponse|bool
     */
    public function SendInvoiceAsEmail(\StructType\SendInvoiceAsEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendInvoiceAsEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendTaxFreeInvoiceData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SendTaxFreeInvoiceData $parameters
     * @return \StructType\SendTaxFreeInvoiceDataResponse|bool
     */
    public function SendTaxFreeInvoiceData(\StructType\SendTaxFreeInvoiceData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendTaxFreeInvoiceData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SendApplicationResponseResponse|\StructType\SendBase64StringEArchiveDataResponse|\StructType\SendBase64StringEArchiveDataWithTemplateCodeResponse|\StructType\SendBase64StringInvoiceResponse|\StructType\SendBase64StringInvoiceWithTemplateCodeResponse|\StructType\SendCumulativeInvoiceDataResponse|\StructType\SendEArchiveDataResponse|\StructType\SendEArchiveDataWithTemplateCodeResponse|\StructType\SendInvoiceAsEmailResponse|\StructType\SendInvoiceDataResponse|\StructType\SendInvoiceDataWithTemplateCodeResponse|\StructType\SendMailQueueAgainResponseResponse|\StructType\SendTaxFreeInvoiceDataResponse|\StructType\SendUBLInvoiceResponse|\StructType\SendXmlInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
