<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Re ServiceType
 * @subpackage Services
 */
class Re extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReSendInvoiceData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReSendInvoiceData $parameters
     * @return \StructType\ReSendInvoiceDataResponse|bool
     */
    public function ReSendInvoiceData(\StructType\ReSendInvoiceData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReSendInvoiceData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReSendInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReSendInvoice $parameters
     * @return \StructType\ReSendInvoiceResponse|bool
     */
    public function ReSendInvoice(\StructType\ReSendInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReSendInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReSendInvoiceDataResponse|\StructType\ReSendInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
