<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteEArchiveInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteEArchiveInvoice $parameters
     * @return \StructType\DeleteEArchiveInvoiceResponse|bool
     */
    public function DeleteEArchiveInvoice(\StructType\DeleteEArchiveInvoice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteEArchiveInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteEArchiveReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteEArchiveReport $parameters
     * @return \StructType\DeleteEArchiveReportResponse|bool
     */
    public function DeleteEArchiveReport(\StructType\DeleteEArchiveReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeleteEArchiveReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteEArchiveInvoiceResponse|\StructType\DeleteEArchiveReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
