<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Xml ServiceType
 * @subpackage Services
 */
class Xml extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named XmlArtigos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\XmlArtigos $parameters
     * @return \LGRAVE\StructType\XmlArtigosResponse|bool
     */
    public function XmlArtigos(\LGRAVE\StructType\XmlArtigos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->XmlArtigos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named XmlStockArtigos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\XmlStockArtigos $parameters
     * @return \LGRAVE\StructType\XmlStockArtigosResponse|bool
     */
    public function XmlStockArtigos(\LGRAVE\StructType\XmlStockArtigos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->XmlStockArtigos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\XmlArtigosResponse|\LGRAVE\StructType\XmlStockArtigosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
