<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Marcar ServiceType
 * @subpackage Services
 */
class Marcar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named MarcarArtigos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\MarcarArtigos $parameters
     * @return \LGRAVE\StructType\MarcarArtigosResponse|bool
     */
    public function MarcarArtigos(\LGRAVE\StructType\MarcarArtigos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarcarArtigos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named MarcarImagensArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\MarcarImagensArtigo $parameters
     * @return \LGRAVE\StructType\MarcarImagensArtigoResponse|bool
     */
    public function MarcarImagensArtigo(\LGRAVE\StructType\MarcarImagensArtigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->MarcarImagensArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\MarcarArtigosResponse|\LGRAVE\StructType\MarcarImagensArtigoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
