<?php

namespace LGRAVE\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desmarcar ServiceType
 * @subpackage Services
 */
class Desmarcar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DesmarcarImagensArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\DesmarcarImagensArtigo $parameters
     * @return \LGRAVE\StructType\DesmarcarImagensArtigoResponse|bool
     */
    public function DesmarcarImagensArtigo(\LGRAVE\StructType\DesmarcarImagensArtigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesmarcarImagensArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesmarcarArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \LGRAVE\StructType\DesmarcarArtigo $parameters
     * @return \LGRAVE\StructType\DesmarcarArtigoResponse|bool
     */
    public function DesmarcarArtigo(\LGRAVE\StructType\DesmarcarArtigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DesmarcarArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGRAVE\StructType\DesmarcarArtigoResponse|\LGRAVE\StructType\DesmarcarImagensArtigoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
