<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://nortemoda.dyndns.org/wssite/ServiceSite.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://nortemoda.dyndns.org/wssite/ServiceSite.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LGRAVE\ClassMap::get(),
);
/**
 * Samples for Xml ServiceType
 */
$xml = new \LGRAVE\ServiceType\Xml($options);
/**
 * Sample call for XmlArtigos operation/method
 */
if ($xml->XmlArtigos(new \LGRAVE\StructType\XmlArtigos()) !== false) {
    print_r($xml->getResult());
} else {
    print_r($xml->getLastError());
}
/**
 * Sample call for XmlStockArtigos operation/method
 */
if ($xml->XmlStockArtigos(new \LGRAVE\StructType\XmlStockArtigos()) !== false) {
    print_r($xml->getResult());
} else {
    print_r($xml->getLastError());
}
/**
 * Samples for Marcar ServiceType
 */
$marcar = new \LGRAVE\ServiceType\Marcar($options);
/**
 * Sample call for MarcarArtigos operation/method
 */
if ($marcar->MarcarArtigos(new \LGRAVE\StructType\MarcarArtigos()) !== false) {
    print_r($marcar->getResult());
} else {
    print_r($marcar->getLastError());
}
/**
 * Sample call for MarcarImagensArtigo operation/method
 */
if ($marcar->MarcarImagensArtigo(new \LGRAVE\StructType\MarcarImagensArtigo()) !== false) {
    print_r($marcar->getResult());
} else {
    print_r($marcar->getLastError());
}
/**
 * Samples for Desmarcar ServiceType
 */
$desmarcar = new \LGRAVE\ServiceType\Desmarcar($options);
/**
 * Sample call for DesmarcarImagensArtigo operation/method
 */
if ($desmarcar->DesmarcarImagensArtigo(new \LGRAVE\StructType\DesmarcarImagensArtigo()) !== false) {
    print_r($desmarcar->getResult());
} else {
    print_r($desmarcar->getLastError());
}
/**
 * Sample call for DesmarcarArtigo operation/method
 */
if ($desmarcar->DesmarcarArtigo(new \LGRAVE\StructType\DesmarcarArtigo()) !== false) {
    print_r($desmarcar->getResult());
} else {
    print_r($desmarcar->getLastError());
}
/**
 * Samples for Sincroniza ServiceType
 */
$sincroniza = new \LGRAVE\ServiceType\Sincroniza($options);
/**
 * Sample call for SincronizaImagens operation/method
 */
if ($sincroniza->SincronizaImagens(new \LGRAVE\StructType\SincronizaImagens()) !== false) {
    print_r($sincroniza->getResult());
} else {
    print_r($sincroniza->getLastError());
}
