<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for returnDocumentProfileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Returned during getting list of profiles
 * @subpackage Structs
 */
class ReturnDocumentProfileType extends AbstractStructBase
{
    /**
     * The idProfile
     * Meta information extracted from the WSDL
     * - documentation: Required during updating profile. Returned during getting list of profiles.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $idProfile;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 120
     * @var string
     */
    public $name;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name2;
    /**
     * The friendlyName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * @var string
     */
    public $friendlyName;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 70
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * @var string
     */
    public $houseNumber;
    /**
     * The premisesNumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $premisesNumber;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 35
     * @var string
     */
    public $city;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * - whiteSpace: collapse
     * @var string
     */
    public $postalCode;
    /**
     * The mobile
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $mobile;
    /**
     * The phonenumber
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $phonenumber;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The default
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $default;
    /**
     * Constructor method for returnDocumentProfileType
     * @uses ReturnDocumentProfileType::setIdProfile()
     * @uses ReturnDocumentProfileType::setName()
     * @uses ReturnDocumentProfileType::setName2()
     * @uses ReturnDocumentProfileType::setFriendlyName()
     * @uses ReturnDocumentProfileType::setStreet()
     * @uses ReturnDocumentProfileType::setHouseNumber()
     * @uses ReturnDocumentProfileType::setPremisesNumber()
     * @uses ReturnDocumentProfileType::setCity()
     * @uses ReturnDocumentProfileType::setPostalCode()
     * @uses ReturnDocumentProfileType::setMobile()
     * @uses ReturnDocumentProfileType::setPhonenumber()
     * @uses ReturnDocumentProfileType::setEmail()
     * @uses ReturnDocumentProfileType::setDefault()
     * @param int $idProfile
     * @param string $name
     * @param string $name2
     * @param string $friendlyName
     * @param string $street
     * @param string $houseNumber
     * @param string $premisesNumber
     * @param string $city
     * @param string $postalCode
     * @param string $mobile
     * @param string $phonenumber
     * @param string $email
     * @param bool $default
     */
    public function __construct($idProfile = null, $name = null, $name2 = null, $friendlyName = null, $street = null, $houseNumber = null, $premisesNumber = null, $city = null, $postalCode = null, $mobile = null, $phonenumber = null, $email = null, $default = null)
    {
        $this
            ->setIdProfile($idProfile)
            ->setName($name)
            ->setName2($name2)
            ->setFriendlyName($friendlyName)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setPremisesNumber($premisesNumber)
            ->setCity($city)
            ->setPostalCode($postalCode)
            ->setMobile($mobile)
            ->setPhonenumber($phonenumber)
            ->setEmail($email)
            ->setDefault($default);
    }
    /**
     * Get idProfile value
     * @return int|null
     */
    public function getIdProfile()
    {
        return $this->idProfile;
    }
    /**
     * Set idProfile value
     * @param int $idProfile
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setIdProfile($idProfile = null)
    {
        // validation for constraint: int
        if (!is_null($idProfile) && !(is_int($idProfile) || ctype_digit($idProfile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idProfile, true), gettype($idProfile)), __LINE__);
        }
        $this->idProfile = $idProfile;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($name) && mb_strlen($name) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get name2 value
     * @return string|null
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($name2) && mb_strlen($name2) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get friendlyName value
     * @return string|null
     */
    public function getFriendlyName()
    {
        return $this->friendlyName;
    }
    /**
     * Set friendlyName value
     * @param string $friendlyName
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setFriendlyName($friendlyName = null)
    {
        // validation for constraint: string
        if (!is_null($friendlyName) && !is_string($friendlyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($friendlyName, true), gettype($friendlyName)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($friendlyName) && mb_strlen($friendlyName) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($friendlyName)), __LINE__);
        }
        $this->friendlyName = $friendlyName;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($street) && mb_strlen($street) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($houseNumber) && mb_strlen($houseNumber) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($houseNumber)), __LINE__);
        }
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get premisesNumber value
     * @return string|null
     */
    public function getPremisesNumber()
    {
        return $this->premisesNumber;
    }
    /**
     * Set premisesNumber value
     * @param string $premisesNumber
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setPremisesNumber($premisesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($premisesNumber) && !is_string($premisesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premisesNumber, true), gettype($premisesNumber)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($premisesNumber) && mb_strlen($premisesNumber) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($premisesNumber)), __LINE__);
        }
        $this->premisesNumber = $premisesNumber;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($city) && mb_strlen($city) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get mobile value
     * @return string|null
     */
    public function getMobile()
    {
        return $this->mobile;
    }
    /**
     * Set mobile value
     * @param string $mobile
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setMobile($mobile = null)
    {
        // validation for constraint: string
        if (!is_null($mobile) && !is_string($mobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile, true), gettype($mobile)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($mobile) && mb_strlen($mobile) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($mobile)), __LINE__);
        }
        $this->mobile = $mobile;
        return $this;
    }
    /**
     * Get phonenumber value
     * @return string|null
     */
    public function getPhonenumber()
    {
        return $this->phonenumber;
    }
    /**
     * Set phonenumber value
     * @param string $phonenumber
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setPhonenumber($phonenumber = null)
    {
        // validation for constraint: string
        if (!is_null($phonenumber) && !is_string($phonenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phonenumber, true), gettype($phonenumber)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($phonenumber) && mb_strlen($phonenumber) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($phonenumber)), __LINE__);
        }
        $this->phonenumber = $phonenumber;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($email) && mb_strlen($email) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get default value
     * @return bool|null
     */
    public function getDefault()
    {
        return $this->default;
    }
    /**
     * Set default value
     * @param bool $default
     * @return \StructType\ReturnDocumentProfileType
     */
    public function setDefault($default = null)
    {
        // validation for constraint: boolean
        if (!is_null($default) && !is_bool($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default, true), gettype($default)), __LINE__);
        }
        $this->default = $default;
        return $this;
    }
}
