<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reklamowanaPrzesylkaType StructType
 * @subpackage Structs
 */
class ReklamowanaPrzesylkaType extends AbstractStructBase
{
    /**
     * The przesylka
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PrzesylkaType
     */
    public $przesylka;
    /**
     * The powodReklamacji
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PowodReklamacjiType
     */
    public $powodReklamacji;
    /**
     * The dataNadania
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $dataNadania;
    /**
     * The nrb
     * Meta information extracted from the WSDL
     * - documentation: Numer rachunku bankowego na który ma zostać przekazane ewentualne odszkodowanie z tytułu złożonej reklamacji.
     * - base: xsd:string
     * - maxLength: 26
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nrb;
    /**
     * The numerFaktury
     * Meta information extracted from the WSDL
     * - documentation: Numer dokumentu powiązanego z reklamowaną przesyłką.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $numerFaktury;
    /**
     * The ezgoda
     * Meta information extracted from the WSDL
     * - documentation: Znacznik decydujący o zgodzie na otrzymywanie drogą elektroniczną powiadomień o rozpatrywanej reklamacji.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ezgoda;
    /**
     * The urzadNadania
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * @var int
     */
    public $urzadNadania;
    /**
     * The powodReklamacjiOpis
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $powodReklamacjiOpis;
    /**
     * The odszkodowanie
     * @var int
     */
    public $odszkodowanie;
    /**
     * The oplata
     * @var int
     */
    public $oplata;
    /**
     * The oczekiwaneOdszkodowanie
     * @var int
     */
    public $oczekiwaneOdszkodowanie;
    /**
     * Constructor method for reklamowanaPrzesylkaType
     * @uses ReklamowanaPrzesylkaType::setPrzesylka()
     * @uses ReklamowanaPrzesylkaType::setPowodReklamacji()
     * @uses ReklamowanaPrzesylkaType::setDataNadania()
     * @uses ReklamowanaPrzesylkaType::setNrb()
     * @uses ReklamowanaPrzesylkaType::setNumerFaktury()
     * @uses ReklamowanaPrzesylkaType::setEzgoda()
     * @uses ReklamowanaPrzesylkaType::setUrzadNadania()
     * @uses ReklamowanaPrzesylkaType::setPowodReklamacjiOpis()
     * @uses ReklamowanaPrzesylkaType::setOdszkodowanie()
     * @uses ReklamowanaPrzesylkaType::setOplata()
     * @uses ReklamowanaPrzesylkaType::setOczekiwaneOdszkodowanie()
     * @param \StructType\PrzesylkaType $przesylka
     * @param \StructType\PowodReklamacjiType $powodReklamacji
     * @param string $dataNadania
     * @param string $nrb
     * @param string $numerFaktury
     * @param bool $ezgoda
     * @param int $urzadNadania
     * @param string $powodReklamacjiOpis
     * @param int $odszkodowanie
     * @param int $oplata
     * @param int $oczekiwaneOdszkodowanie
     */
    public function __construct(\StructType\PrzesylkaType $przesylka = null, \StructType\PowodReklamacjiType $powodReklamacji = null, $dataNadania = null, $nrb = null, $numerFaktury = null, $ezgoda = null, $urzadNadania = null, $powodReklamacjiOpis = null, $odszkodowanie = null, $oplata = null, $oczekiwaneOdszkodowanie = null)
    {
        $this
            ->setPrzesylka($przesylka)
            ->setPowodReklamacji($powodReklamacji)
            ->setDataNadania($dataNadania)
            ->setNrb($nrb)
            ->setNumerFaktury($numerFaktury)
            ->setEzgoda($ezgoda)
            ->setUrzadNadania($urzadNadania)
            ->setPowodReklamacjiOpis($powodReklamacjiOpis)
            ->setOdszkodowanie($odszkodowanie)
            ->setOplata($oplata)
            ->setOczekiwaneOdszkodowanie($oczekiwaneOdszkodowanie);
    }
    /**
     * Get przesylka value
     * @return \StructType\PrzesylkaType
     */
    public function getPrzesylka()
    {
        return $this->przesylka;
    }
    /**
     * Set przesylka value
     * @param \StructType\PrzesylkaType $przesylka
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setPrzesylka(\StructType\PrzesylkaType $przesylka = null)
    {
        $this->przesylka = $przesylka;
        return $this;
    }
    /**
     * Get powodReklamacji value
     * @return \StructType\PowodReklamacjiType
     */
    public function getPowodReklamacji()
    {
        return $this->powodReklamacji;
    }
    /**
     * Set powodReklamacji value
     * @param \StructType\PowodReklamacjiType $powodReklamacji
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setPowodReklamacji(\StructType\PowodReklamacjiType $powodReklamacji = null)
    {
        $this->powodReklamacji = $powodReklamacji;
        return $this;
    }
    /**
     * Get dataNadania value
     * @return string
     */
    public function getDataNadania()
    {
        return $this->dataNadania;
    }
    /**
     * Set dataNadania value
     * @param string $dataNadania
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setDataNadania($dataNadania = null)
    {
        // validation for constraint: string
        if (!is_null($dataNadania) && !is_string($dataNadania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNadania, true), gettype($dataNadania)), __LINE__);
        }
        $this->dataNadania = $dataNadania;
        return $this;
    }
    /**
     * Get nrb value
     * @return string|null
     */
    public function getNrb()
    {
        return $this->nrb;
    }
    /**
     * Set nrb value
     * @param string $nrb
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setNrb($nrb = null)
    {
        // validation for constraint: string
        if (!is_null($nrb) && !is_string($nrb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrb, true), gettype($nrb)), __LINE__);
        }
        // validation for constraint: maxLength(26)
        if (!is_null($nrb) && mb_strlen($nrb) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 26', mb_strlen($nrb)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nrb) && mb_strlen($nrb) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nrb)), __LINE__);
        }
        $this->nrb = $nrb;
        return $this;
    }
    /**
     * Get numerFaktury value
     * @return string|null
     */
    public function getNumerFaktury()
    {
        return $this->numerFaktury;
    }
    /**
     * Set numerFaktury value
     * @param string $numerFaktury
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setNumerFaktury($numerFaktury = null)
    {
        // validation for constraint: string
        if (!is_null($numerFaktury) && !is_string($numerFaktury)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerFaktury, true), gettype($numerFaktury)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($numerFaktury) && mb_strlen($numerFaktury) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($numerFaktury)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($numerFaktury) && mb_strlen($numerFaktury) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($numerFaktury)), __LINE__);
        }
        $this->numerFaktury = $numerFaktury;
        return $this;
    }
    /**
     * Get ezgoda value
     * @return bool|null
     */
    public function getEzgoda()
    {
        return $this->ezgoda;
    }
    /**
     * Set ezgoda value
     * @param bool $ezgoda
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setEzgoda($ezgoda = null)
    {
        // validation for constraint: boolean
        if (!is_null($ezgoda) && !is_bool($ezgoda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ezgoda, true), gettype($ezgoda)), __LINE__);
        }
        $this->ezgoda = $ezgoda;
        return $this;
    }
    /**
     * Get urzadNadania value
     * @return int|null
     */
    public function getUrzadNadania()
    {
        return $this->urzadNadania;
    }
    /**
     * Set urzadNadania value
     * @param int $urzadNadania
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setUrzadNadania($urzadNadania = null)
    {
        // validation for constraint: int
        if (!is_null($urzadNadania) && !(is_int($urzadNadania) || ctype_digit($urzadNadania))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urzadNadania, true), gettype($urzadNadania)), __LINE__);
        }
        $this->urzadNadania = $urzadNadania;
        return $this;
    }
    /**
     * Get powodReklamacjiOpis value
     * @return string|null
     */
    public function getPowodReklamacjiOpis()
    {
        return $this->powodReklamacjiOpis;
    }
    /**
     * Set powodReklamacjiOpis value
     * @param string $powodReklamacjiOpis
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setPowodReklamacjiOpis($powodReklamacjiOpis = null)
    {
        // validation for constraint: string
        if (!is_null($powodReklamacjiOpis) && !is_string($powodReklamacjiOpis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($powodReklamacjiOpis, true), gettype($powodReklamacjiOpis)), __LINE__);
        }
        $this->powodReklamacjiOpis = $powodReklamacjiOpis;
        return $this;
    }
    /**
     * Get odszkodowanie value
     * @return int|null
     */
    public function getOdszkodowanie()
    {
        return $this->odszkodowanie;
    }
    /**
     * Set odszkodowanie value
     * @param int $odszkodowanie
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setOdszkodowanie($odszkodowanie = null)
    {
        // validation for constraint: int
        if (!is_null($odszkodowanie) && !(is_int($odszkodowanie) || ctype_digit($odszkodowanie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odszkodowanie, true), gettype($odszkodowanie)), __LINE__);
        }
        $this->odszkodowanie = $odszkodowanie;
        return $this;
    }
    /**
     * Get oplata value
     * @return int|null
     */
    public function getOplata()
    {
        return $this->oplata;
    }
    /**
     * Set oplata value
     * @param int $oplata
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setOplata($oplata = null)
    {
        // validation for constraint: int
        if (!is_null($oplata) && !(is_int($oplata) || ctype_digit($oplata))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oplata, true), gettype($oplata)), __LINE__);
        }
        $this->oplata = $oplata;
        return $this;
    }
    /**
     * Get oczekiwaneOdszkodowanie value
     * @return int|null
     */
    public function getOczekiwaneOdszkodowanie()
    {
        return $this->oczekiwaneOdszkodowanie;
    }
    /**
     * Set oczekiwaneOdszkodowanie value
     * @param int $oczekiwaneOdszkodowanie
     * @return \StructType\ReklamowanaPrzesylkaType
     */
    public function setOczekiwaneOdszkodowanie($oczekiwaneOdszkodowanie = null)
    {
        // validation for constraint: int
        if (!is_null($oczekiwaneOdszkodowanie) && !(is_int($oczekiwaneOdszkodowanie) || ctype_digit($oczekiwaneOdszkodowanie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oczekiwaneOdszkodowanie, true), gettype($oczekiwaneOdszkodowanie)), __LINE__);
        }
        $this->oczekiwaneOdszkodowanie = $oczekiwaneOdszkodowanie;
        return $this;
    }
}
