<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidationResult
 * @subpackage Structs
 */
class ValidationResult extends AbstractStructBase
{
    /**
     * The Annotations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SerializableDictionaryOfstringstring
     */
    public $Annotations;
    /**
     * The FailedValidationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailedValidationDescription;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The Successful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Successful;
    /**
     * Constructor method for ValidationResult
     * @uses ValidationResult::setAnnotations()
     * @uses ValidationResult::setFailedValidationDescription()
     * @uses ValidationResult::setKey()
     * @uses ValidationResult::setSuccessful()
     * @param \StructType\SerializableDictionaryOfstringstring $annotations
     * @param string $failedValidationDescription
     * @param string $key
     * @param bool $successful
     */
    public function __construct(\StructType\SerializableDictionaryOfstringstring $annotations = null, $failedValidationDescription = null, $key = null, $successful = null)
    {
        $this
            ->setAnnotations($annotations)
            ->setFailedValidationDescription($failedValidationDescription)
            ->setKey($key)
            ->setSuccessful($successful);
    }
    /**
     * Get Annotations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SerializableDictionaryOfstringstring|null
     */
    public function getAnnotations()
    {
        return isset($this->Annotations) ? $this->Annotations : null;
    }
    /**
     * Set Annotations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SerializableDictionaryOfstringstring $annotations
     * @return \StructType\ValidationResult
     */
    public function setAnnotations(\StructType\SerializableDictionaryOfstringstring $annotations = null)
    {
        if (is_null($annotations) || (is_array($annotations) && empty($annotations))) {
            unset($this->Annotations);
        } else {
            $this->Annotations = $annotations;
        }
        return $this;
    }
    /**
     * Get FailedValidationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailedValidationDescription()
    {
        return isset($this->FailedValidationDescription) ? $this->FailedValidationDescription : null;
    }
    /**
     * Set FailedValidationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failedValidationDescription
     * @return \StructType\ValidationResult
     */
    public function setFailedValidationDescription($failedValidationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($failedValidationDescription) && !is_string($failedValidationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failedValidationDescription, true), gettype($failedValidationDescription)), __LINE__);
        }
        if (is_null($failedValidationDescription) || (is_array($failedValidationDescription) && empty($failedValidationDescription))) {
            unset($this->FailedValidationDescription);
        } else {
            $this->FailedValidationDescription = $failedValidationDescription;
        }
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\ValidationResult
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get Successful value
     * @return bool|null
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\ValidationResult
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
}
