<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StateMessage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StateMessage
 * @subpackage Structs
 */
class StateMessage extends AbstractStructBase
{
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * Constructor method for StateMessage
     * @uses StateMessage::setState()
     * @param string $state
     */
    public function __construct($state = null)
    {
        $this
            ->setState($state);
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\MessageState::valueIsValid()
     * @uses \EnumType\MessageState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\StateMessage
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\MessageState::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
}
