<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResponseBase
 * @subpackage Structs
 */
class ResponseBase extends AbstractStructBase
{
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PageSize;
    /**
     * The LastID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LastID;
    /**
     * The TotalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalCount;
    /**
     * The CultureCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureCode;
    /**
     * Constructor method for ResponseBase
     * @uses ResponseBase::setPageSize()
     * @uses ResponseBase::setLastID()
     * @uses ResponseBase::setTotalCount()
     * @uses ResponseBase::setCultureCode()
     * @param int $pageSize
     * @param int $lastID
     * @param int $totalCount
     * @param string $cultureCode
     */
    public function __construct($pageSize = null, $lastID = null, $totalCount = null, $cultureCode = null)
    {
        $this
            ->setPageSize($pageSize)
            ->setLastID($lastID)
            ->setTotalCount($totalCount)
            ->setCultureCode($cultureCode);
    }
    /**
     * Get PageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\ResponseBase
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get LastID value
     * @return int|null
     */
    public function getLastID()
    {
        return $this->LastID;
    }
    /**
     * Set LastID value
     * @param int $lastID
     * @return \StructType\ResponseBase
     */
    public function setLastID($lastID = null)
    {
        // validation for constraint: int
        if (!is_null($lastID) && !(is_int($lastID) || ctype_digit($lastID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastID, true), gettype($lastID)), __LINE__);
        }
        $this->LastID = $lastID;
        return $this;
    }
    /**
     * Get TotalCount value
     * @return int|null
     */
    public function getTotalCount()
    {
        return $this->TotalCount;
    }
    /**
     * Set TotalCount value
     * @param int $totalCount
     * @return \StructType\ResponseBase
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->TotalCount = $totalCount;
        return $this;
    }
    /**
     * Get CultureCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureCode()
    {
        return isset($this->CultureCode) ? $this->CultureCode : null;
    }
    /**
     * Set CultureCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureCode
     * @return \StructType\ResponseBase
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureCode, true), gettype($cultureCode)), __LINE__);
        }
        if (is_null($cultureCode) || (is_array($cultureCode) && empty($cultureCode))) {
            unset($this->CultureCode);
        } else {
            $this->CultureCode = $cultureCode;
        }
        return $this;
    }
}
