<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RequestBase
 * @subpackage Structs
 */
class RequestBase extends AbstractStructBase
{
    /**
     * The ActiveOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ActiveOnly;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PageSize;
    /**
     * The LastID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LastID;
    /**
     * The LastCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastCode;
    /**
     * The CultureCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureCode;
    /**
     * The GetTotalCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetTotalCount;
    /**
     * Constructor method for RequestBase
     * @uses RequestBase::setActiveOnly()
     * @uses RequestBase::setPageSize()
     * @uses RequestBase::setLastID()
     * @uses RequestBase::setLastCode()
     * @uses RequestBase::setCultureCode()
     * @uses RequestBase::setGetTotalCount()
     * @param bool $activeOnly
     * @param int $pageSize
     * @param int $lastID
     * @param string $lastCode
     * @param string $cultureCode
     * @param bool $getTotalCount
     */
    public function __construct($activeOnly = null, $pageSize = null, $lastID = null, $lastCode = null, $cultureCode = null, $getTotalCount = null)
    {
        $this
            ->setActiveOnly($activeOnly)
            ->setPageSize($pageSize)
            ->setLastID($lastID)
            ->setLastCode($lastCode)
            ->setCultureCode($cultureCode)
            ->setGetTotalCount($getTotalCount);
    }
    /**
     * Get ActiveOnly value
     * @return bool|null
     */
    public function getActiveOnly()
    {
        return $this->ActiveOnly;
    }
    /**
     * Set ActiveOnly value
     * @param bool $activeOnly
     * @return \StructType\RequestBase
     */
    public function setActiveOnly($activeOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeOnly) && !is_bool($activeOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeOnly, true), gettype($activeOnly)), __LINE__);
        }
        $this->ActiveOnly = $activeOnly;
        return $this;
    }
    /**
     * Get PageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \StructType\RequestBase
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get LastID value
     * @return int|null
     */
    public function getLastID()
    {
        return $this->LastID;
    }
    /**
     * Set LastID value
     * @param int $lastID
     * @return \StructType\RequestBase
     */
    public function setLastID($lastID = null)
    {
        // validation for constraint: int
        if (!is_null($lastID) && !(is_int($lastID) || ctype_digit($lastID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastID, true), gettype($lastID)), __LINE__);
        }
        $this->LastID = $lastID;
        return $this;
    }
    /**
     * Get LastCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastCode()
    {
        return isset($this->LastCode) ? $this->LastCode : null;
    }
    /**
     * Set LastCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastCode
     * @return \StructType\RequestBase
     */
    public function setLastCode($lastCode = null)
    {
        // validation for constraint: string
        if (!is_null($lastCode) && !is_string($lastCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastCode, true), gettype($lastCode)), __LINE__);
        }
        if (is_null($lastCode) || (is_array($lastCode) && empty($lastCode))) {
            unset($this->LastCode);
        } else {
            $this->LastCode = $lastCode;
        }
        return $this;
    }
    /**
     * Get CultureCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureCode()
    {
        return isset($this->CultureCode) ? $this->CultureCode : null;
    }
    /**
     * Set CultureCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureCode
     * @return \StructType\RequestBase
     */
    public function setCultureCode($cultureCode = null)
    {
        // validation for constraint: string
        if (!is_null($cultureCode) && !is_string($cultureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureCode, true), gettype($cultureCode)), __LINE__);
        }
        if (is_null($cultureCode) || (is_array($cultureCode) && empty($cultureCode))) {
            unset($this->CultureCode);
        } else {
            $this->CultureCode = $cultureCode;
        }
        return $this;
    }
    /**
     * Get GetTotalCount value
     * @return bool|null
     */
    public function getGetTotalCount()
    {
        return $this->GetTotalCount;
    }
    /**
     * Set GetTotalCount value
     * @param bool $getTotalCount
     * @return \StructType\RequestBase
     */
    public function setGetTotalCount($getTotalCount = null)
    {
        // validation for constraint: boolean
        if (!is_null($getTotalCount) && !is_bool($getTotalCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getTotalCount, true), gettype($getTotalCount)), __LINE__);
        }
        $this->GetTotalCount = $getTotalCount;
        return $this;
    }
}
