<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherServiceInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OtherServiceInformation
 * @subpackage Structs
 */
class OtherServiceInformation extends AbstractStructBase
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Text;
    /**
     * The OsiSeverity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OsiSeverity;
    /**
     * The OSITypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OSITypeCode;
    /**
     * The SubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubType;
    /**
     * Constructor method for OtherServiceInformation
     * @uses OtherServiceInformation::setText()
     * @uses OtherServiceInformation::setOsiSeverity()
     * @uses OtherServiceInformation::setOSITypeCode()
     * @uses OtherServiceInformation::setSubType()
     * @param string $text
     * @param string $osiSeverity
     * @param string $oSITypeCode
     * @param string $subType
     */
    public function __construct($text = null, $osiSeverity = null, $oSITypeCode = null, $subType = null)
    {
        $this
            ->setText($text)
            ->setOsiSeverity($osiSeverity)
            ->setOSITypeCode($oSITypeCode)
            ->setSubType($subType);
    }
    /**
     * Get Text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->Text) ? $this->Text : null;
    }
    /**
     * Set Text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\OtherServiceInformation
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->Text);
        } else {
            $this->Text = $text;
        }
        return $this;
    }
    /**
     * Get OsiSeverity value
     * @return string|null
     */
    public function getOsiSeverity()
    {
        return $this->OsiSeverity;
    }
    /**
     * Set OsiSeverity value
     * @uses \EnumType\OSISeverity::valueIsValid()
     * @uses \EnumType\OSISeverity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $osiSeverity
     * @return \StructType\OtherServiceInformation
     */
    public function setOsiSeverity($osiSeverity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OSISeverity::valueIsValid($osiSeverity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OSISeverity', is_array($osiSeverity) ? implode(', ', $osiSeverity) : var_export($osiSeverity, true), implode(', ', \EnumType\OSISeverity::getValidValues())), __LINE__);
        }
        $this->OsiSeverity = $osiSeverity;
        return $this;
    }
    /**
     * Get OSITypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOSITypeCode()
    {
        return isset($this->OSITypeCode) ? $this->OSITypeCode : null;
    }
    /**
     * Set OSITypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oSITypeCode
     * @return \StructType\OtherServiceInformation
     */
    public function setOSITypeCode($oSITypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($oSITypeCode) && !is_string($oSITypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oSITypeCode, true), gettype($oSITypeCode)), __LINE__);
        }
        if (is_null($oSITypeCode) || (is_array($oSITypeCode) && empty($oSITypeCode))) {
            unset($this->OSITypeCode);
        } else {
            $this->OSITypeCode = $oSITypeCode;
        }
        return $this;
    }
    /**
     * Get SubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubType()
    {
        return isset($this->SubType) ? $this->SubType : null;
    }
    /**
     * Set SubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subType
     * @return \StructType\OtherServiceInformation
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subType, true), gettype($subType)), __LINE__);
        }
        if (is_null($subType) || (is_array($subType) && empty($subType))) {
            unset($this->SubType);
        } else {
            $this->SubType = $subType;
        }
        return $this;
    }
}
