<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifiedMessage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifiedMessage
 * @subpackage Structs
 */
class ModifiedMessage extends StateMessage
{
    /**
     * The CreatedAgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CreatedAgentID;
    /**
     * The CreatedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDate;
    /**
     * The ModifiedAgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ModifiedAgentID;
    /**
     * The ModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifiedDate;
    /**
     * Constructor method for ModifiedMessage
     * @uses ModifiedMessage::setCreatedAgentID()
     * @uses ModifiedMessage::setCreatedDate()
     * @uses ModifiedMessage::setModifiedAgentID()
     * @uses ModifiedMessage::setModifiedDate()
     * @param int $createdAgentID
     * @param string $createdDate
     * @param int $modifiedAgentID
     * @param string $modifiedDate
     */
    public function __construct($createdAgentID = null, $createdDate = null, $modifiedAgentID = null, $modifiedDate = null)
    {
        $this
            ->setCreatedAgentID($createdAgentID)
            ->setCreatedDate($createdDate)
            ->setModifiedAgentID($modifiedAgentID)
            ->setModifiedDate($modifiedDate);
    }
    /**
     * Get CreatedAgentID value
     * @return int|null
     */
    public function getCreatedAgentID()
    {
        return $this->CreatedAgentID;
    }
    /**
     * Set CreatedAgentID value
     * @param int $createdAgentID
     * @return \StructType\ModifiedMessage
     */
    public function setCreatedAgentID($createdAgentID = null)
    {
        // validation for constraint: int
        if (!is_null($createdAgentID) && !(is_int($createdAgentID) || ctype_digit($createdAgentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createdAgentID, true), gettype($createdAgentID)), __LINE__);
        }
        $this->CreatedAgentID = $createdAgentID;
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\ModifiedMessage
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get ModifiedAgentID value
     * @return int|null
     */
    public function getModifiedAgentID()
    {
        return $this->ModifiedAgentID;
    }
    /**
     * Set ModifiedAgentID value
     * @param int $modifiedAgentID
     * @return \StructType\ModifiedMessage
     */
    public function setModifiedAgentID($modifiedAgentID = null)
    {
        // validation for constraint: int
        if (!is_null($modifiedAgentID) && !(is_int($modifiedAgentID) || ctype_digit($modifiedAgentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modifiedAgentID, true), gettype($modifiedAgentID)), __LINE__);
        }
        $this->ModifiedAgentID = $modifiedAgentID;
        return $this;
    }
    /**
     * Get ModifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->ModifiedDate;
    }
    /**
     * Set ModifiedDate value
     * @param string $modifiedDate
     * @return \StructType\ModifiedMessage
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifiedDate, true), gettype($modifiedDate)), __LINE__);
        }
        $this->ModifiedDate = $modifiedDate;
        return $this;
    }
}
