<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountByReferenceRequestData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAccountByReferenceRequestData
 * @subpackage Structs
 */
class GetAccountByReferenceRequestData extends AbstractStructBase
{
    /**
     * The AccountReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountReference;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AccountHolderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolderType;
    /**
     * Constructor method for GetAccountByReferenceRequestData
     * @uses GetAccountByReferenceRequestData::setAccountReference()
     * @uses GetAccountByReferenceRequestData::setCurrencyCode()
     * @uses GetAccountByReferenceRequestData::setAccountHolderType()
     * @param string $accountReference
     * @param string $currencyCode
     * @param string $accountHolderType
     */
    public function __construct($accountReference = null, $currencyCode = null, $accountHolderType = null)
    {
        $this
            ->setAccountReference($accountReference)
            ->setCurrencyCode($currencyCode)
            ->setAccountHolderType($accountHolderType);
    }
    /**
     * Get AccountReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountReference()
    {
        return isset($this->AccountReference) ? $this->AccountReference : null;
    }
    /**
     * Set AccountReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountReference
     * @return \StructType\GetAccountByReferenceRequestData
     */
    public function setAccountReference($accountReference = null)
    {
        // validation for constraint: string
        if (!is_null($accountReference) && !is_string($accountReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountReference, true), gettype($accountReference)), __LINE__);
        }
        if (is_null($accountReference) || (is_array($accountReference) && empty($accountReference))) {
            unset($this->AccountReference);
        } else {
            $this->AccountReference = $accountReference;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\GetAccountByReferenceRequestData
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get AccountHolderType value
     * @return string|null
     */
    public function getAccountHolderType()
    {
        return $this->AccountHolderType;
    }
    /**
     * Set AccountHolderType value
     * @uses \EnumType\AccountHolderType::valueIsValid()
     * @uses \EnumType\AccountHolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountHolderType
     * @return \StructType\GetAccountByReferenceRequestData
     */
    public function setAccountHolderType($accountHolderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountHolderType::valueIsValid($accountHolderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountHolderType', is_array($accountHolderType) ? implode(', ', $accountHolderType) : var_export($accountHolderType, true), implode(', ', \EnumType\AccountHolderType::getValidValues())), __LINE__);
        }
        $this->AccountHolderType = $accountHolderType;
        return $this;
    }
}
