<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindAccountTransactionRequestData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindAccountTransactionRequestData
 * @subpackage Structs
 */
class FindAccountTransactionRequestData extends RequestBase
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountCreditID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountCreditID;
    /**
     * The CreatedDateTimeBegin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDateTimeBegin;
    /**
     * The CreatedDateTimeEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDateTimeEnd;
    /**
     * The SortDescending
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SortDescending;
    /**
     * Constructor method for FindAccountTransactionRequestData
     * @uses FindAccountTransactionRequestData::setAccountID()
     * @uses FindAccountTransactionRequestData::setAccountCreditID()
     * @uses FindAccountTransactionRequestData::setCreatedDateTimeBegin()
     * @uses FindAccountTransactionRequestData::setCreatedDateTimeEnd()
     * @uses FindAccountTransactionRequestData::setSortDescending()
     * @param int $accountID
     * @param int $accountCreditID
     * @param string $createdDateTimeBegin
     * @param string $createdDateTimeEnd
     * @param bool $sortDescending
     */
    public function __construct($accountID = null, $accountCreditID = null, $createdDateTimeBegin = null, $createdDateTimeEnd = null, $sortDescending = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountCreditID($accountCreditID)
            ->setCreatedDateTimeBegin($createdDateTimeBegin)
            ->setCreatedDateTimeEnd($createdDateTimeEnd)
            ->setSortDescending($sortDescending);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\FindAccountTransactionRequestData
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountCreditID value
     * @return int|null
     */
    public function getAccountCreditID()
    {
        return $this->AccountCreditID;
    }
    /**
     * Set AccountCreditID value
     * @param int $accountCreditID
     * @return \StructType\FindAccountTransactionRequestData
     */
    public function setAccountCreditID($accountCreditID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCreditID) && !(is_int($accountCreditID) || ctype_digit($accountCreditID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountCreditID, true), gettype($accountCreditID)), __LINE__);
        }
        $this->AccountCreditID = $accountCreditID;
        return $this;
    }
    /**
     * Get CreatedDateTimeBegin value
     * @return string|null
     */
    public function getCreatedDateTimeBegin()
    {
        return $this->CreatedDateTimeBegin;
    }
    /**
     * Set CreatedDateTimeBegin value
     * @param string $createdDateTimeBegin
     * @return \StructType\FindAccountTransactionRequestData
     */
    public function setCreatedDateTimeBegin($createdDateTimeBegin = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateTimeBegin) && !is_string($createdDateTimeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDateTimeBegin, true), gettype($createdDateTimeBegin)), __LINE__);
        }
        $this->CreatedDateTimeBegin = $createdDateTimeBegin;
        return $this;
    }
    /**
     * Get CreatedDateTimeEnd value
     * @return string|null
     */
    public function getCreatedDateTimeEnd()
    {
        return $this->CreatedDateTimeEnd;
    }
    /**
     * Set CreatedDateTimeEnd value
     * @param string $createdDateTimeEnd
     * @return \StructType\FindAccountTransactionRequestData
     */
    public function setCreatedDateTimeEnd($createdDateTimeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateTimeEnd) && !is_string($createdDateTimeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDateTimeEnd, true), gettype($createdDateTimeEnd)), __LINE__);
        }
        $this->CreatedDateTimeEnd = $createdDateTimeEnd;
        return $this;
    }
    /**
     * Get SortDescending value
     * @return bool|null
     */
    public function getSortDescending()
    {
        return $this->SortDescending;
    }
    /**
     * Set SortDescending value
     * @param bool $sortDescending
     * @return \StructType\FindAccountTransactionRequestData
     */
    public function setSortDescending($sortDescending = null)
    {
        // validation for constraint: boolean
        if (!is_null($sortDescending) && !is_bool($sortDescending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sortDescending, true), gettype($sortDescending)), __LINE__);
        }
        $this->SortDescending = $sortDescending;
        return $this;
    }
}
