<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindAccountTransactionItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindAccountTransactionItem
 * @subpackage Structs
 */
class FindAccountTransactionItem extends AbstractStructBase
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountCreditID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountCreditID;
    /**
     * The AccountTransactionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountTransactionID;
    /**
     * The AccountTransactionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountTransactionType;
    /**
     * The AccountTransactionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountTransactionCode;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ForeignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ForeignAmount;
    /**
     * The ForeignCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignCurrencyCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The AccountBatchID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountBatchID;
    /**
     * The AccountBatchReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountBatchReference;
    /**
     * The CreatedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedDate;
    /**
     * The PaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentID;
    /**
     * Constructor method for FindAccountTransactionItem
     * @uses FindAccountTransactionItem::setAccountID()
     * @uses FindAccountTransactionItem::setAccountCreditID()
     * @uses FindAccountTransactionItem::setAccountTransactionID()
     * @uses FindAccountTransactionItem::setAccountTransactionType()
     * @uses FindAccountTransactionItem::setAccountTransactionCode()
     * @uses FindAccountTransactionItem::setReference()
     * @uses FindAccountTransactionItem::setAmount()
     * @uses FindAccountTransactionItem::setCurrencyCode()
     * @uses FindAccountTransactionItem::setForeignAmount()
     * @uses FindAccountTransactionItem::setForeignCurrencyCode()
     * @uses FindAccountTransactionItem::setNote()
     * @uses FindAccountTransactionItem::setAccountBatchID()
     * @uses FindAccountTransactionItem::setAccountBatchReference()
     * @uses FindAccountTransactionItem::setCreatedDate()
     * @uses FindAccountTransactionItem::setPaymentID()
     * @param int $accountID
     * @param int $accountCreditID
     * @param int $accountTransactionID
     * @param string $accountTransactionType
     * @param string $accountTransactionCode
     * @param string $reference
     * @param float $amount
     * @param string $currencyCode
     * @param float $foreignAmount
     * @param string $foreignCurrencyCode
     * @param string $note
     * @param int $accountBatchID
     * @param string $accountBatchReference
     * @param string $createdDate
     * @param int $paymentID
     */
    public function __construct($accountID = null, $accountCreditID = null, $accountTransactionID = null, $accountTransactionType = null, $accountTransactionCode = null, $reference = null, $amount = null, $currencyCode = null, $foreignAmount = null, $foreignCurrencyCode = null, $note = null, $accountBatchID = null, $accountBatchReference = null, $createdDate = null, $paymentID = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountCreditID($accountCreditID)
            ->setAccountTransactionID($accountTransactionID)
            ->setAccountTransactionType($accountTransactionType)
            ->setAccountTransactionCode($accountTransactionCode)
            ->setReference($reference)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setForeignAmount($foreignAmount)
            ->setForeignCurrencyCode($foreignCurrencyCode)
            ->setNote($note)
            ->setAccountBatchID($accountBatchID)
            ->setAccountBatchReference($accountBatchReference)
            ->setCreatedDate($createdDate)
            ->setPaymentID($paymentID);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountCreditID value
     * @return int|null
     */
    public function getAccountCreditID()
    {
        return $this->AccountCreditID;
    }
    /**
     * Set AccountCreditID value
     * @param int $accountCreditID
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountCreditID($accountCreditID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCreditID) && !(is_int($accountCreditID) || ctype_digit($accountCreditID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountCreditID, true), gettype($accountCreditID)), __LINE__);
        }
        $this->AccountCreditID = $accountCreditID;
        return $this;
    }
    /**
     * Get AccountTransactionID value
     * @return int|null
     */
    public function getAccountTransactionID()
    {
        return $this->AccountTransactionID;
    }
    /**
     * Set AccountTransactionID value
     * @param int $accountTransactionID
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountTransactionID($accountTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTransactionID) && !(is_int($accountTransactionID) || ctype_digit($accountTransactionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountTransactionID, true), gettype($accountTransactionID)), __LINE__);
        }
        $this->AccountTransactionID = $accountTransactionID;
        return $this;
    }
    /**
     * Get AccountTransactionType value
     * @return string|null
     */
    public function getAccountTransactionType()
    {
        return $this->AccountTransactionType;
    }
    /**
     * Set AccountTransactionType value
     * @uses \EnumType\AccountTransactionType::valueIsValid()
     * @uses \EnumType\AccountTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountTransactionType
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountTransactionType($accountTransactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountTransactionType::valueIsValid($accountTransactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountTransactionType', is_array($accountTransactionType) ? implode(', ', $accountTransactionType) : var_export($accountTransactionType, true), implode(', ', \EnumType\AccountTransactionType::getValidValues())), __LINE__);
        }
        $this->AccountTransactionType = $accountTransactionType;
        return $this;
    }
    /**
     * Get AccountTransactionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountTransactionCode()
    {
        return isset($this->AccountTransactionCode) ? $this->AccountTransactionCode : null;
    }
    /**
     * Set AccountTransactionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountTransactionCode
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountTransactionCode($accountTransactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountTransactionCode) && !is_string($accountTransactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTransactionCode, true), gettype($accountTransactionCode)), __LINE__);
        }
        if (is_null($accountTransactionCode) || (is_array($accountTransactionCode) && empty($accountTransactionCode))) {
            unset($this->AccountTransactionCode);
        } else {
            $this->AccountTransactionCode = $accountTransactionCode;
        }
        return $this;
    }
    /**
     * Get Reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->Reference) ? $this->Reference : null;
    }
    /**
     * Set Reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \StructType\FindAccountTransactionItem
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->Reference);
        } else {
            $this->Reference = $reference;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\FindAccountTransactionItem
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ForeignAmount value
     * @return float|null
     */
    public function getForeignAmount()
    {
        return $this->ForeignAmount;
    }
    /**
     * Set ForeignAmount value
     * @param float $foreignAmount
     * @return \StructType\FindAccountTransactionItem
     */
    public function setForeignAmount($foreignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($foreignAmount) && !(is_float($foreignAmount) || is_numeric($foreignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignAmount, true), gettype($foreignAmount)), __LINE__);
        }
        $this->ForeignAmount = $foreignAmount;
        return $this;
    }
    /**
     * Get ForeignCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignCurrencyCode()
    {
        return isset($this->ForeignCurrencyCode) ? $this->ForeignCurrencyCode : null;
    }
    /**
     * Set ForeignCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignCurrencyCode
     * @return \StructType\FindAccountTransactionItem
     */
    public function setForeignCurrencyCode($foreignCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($foreignCurrencyCode) && !is_string($foreignCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignCurrencyCode, true), gettype($foreignCurrencyCode)), __LINE__);
        }
        if (is_null($foreignCurrencyCode) || (is_array($foreignCurrencyCode) && empty($foreignCurrencyCode))) {
            unset($this->ForeignCurrencyCode);
        } else {
            $this->ForeignCurrencyCode = $foreignCurrencyCode;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\FindAccountTransactionItem
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get AccountBatchID value
     * @return int|null
     */
    public function getAccountBatchID()
    {
        return $this->AccountBatchID;
    }
    /**
     * Set AccountBatchID value
     * @param int $accountBatchID
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountBatchID($accountBatchID = null)
    {
        // validation for constraint: int
        if (!is_null($accountBatchID) && !(is_int($accountBatchID) || ctype_digit($accountBatchID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountBatchID, true), gettype($accountBatchID)), __LINE__);
        }
        $this->AccountBatchID = $accountBatchID;
        return $this;
    }
    /**
     * Get AccountBatchReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountBatchReference()
    {
        return isset($this->AccountBatchReference) ? $this->AccountBatchReference : null;
    }
    /**
     * Set AccountBatchReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountBatchReference
     * @return \StructType\FindAccountTransactionItem
     */
    public function setAccountBatchReference($accountBatchReference = null)
    {
        // validation for constraint: string
        if (!is_null($accountBatchReference) && !is_string($accountBatchReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountBatchReference, true), gettype($accountBatchReference)), __LINE__);
        }
        if (is_null($accountBatchReference) || (is_array($accountBatchReference) && empty($accountBatchReference))) {
            unset($this->AccountBatchReference);
        } else {
            $this->AccountBatchReference = $accountBatchReference;
        }
        return $this;
    }
    /**
     * Get CreatedDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->CreatedDate;
    }
    /**
     * Set CreatedDate value
     * @param string $createdDate
     * @return \StructType\FindAccountTransactionItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->CreatedDate = $createdDate;
        return $this;
    }
    /**
     * Get PaymentID value
     * @return int|null
     */
    public function getPaymentID()
    {
        return $this->PaymentID;
    }
    /**
     * Set PaymentID value
     * @param int $paymentID
     * @return \StructType\FindAccountTransactionItem
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentID) && !(is_int($paymentID) || ctype_digit($paymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentID, true), gettype($paymentID)), __LINE__);
        }
        $this->PaymentID = $paymentID;
        return $this;
    }
}
