<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableCreditResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AvailableCreditResponse
 * @subpackage Structs
 */
class AvailableCreditResponse extends ResponseBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Account
     */
    public $Account;
    /**
     * The OtherServiceInformations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOtherServiceInformation
     */
    public $OtherServiceInformations;
    /**
     * Constructor method for AvailableCreditResponse
     * @uses AvailableCreditResponse::setAccount()
     * @uses AvailableCreditResponse::setOtherServiceInformations()
     * @param \StructType\Account $account
     * @param \ArrayType\ArrayOfOtherServiceInformation $otherServiceInformations
     */
    public function __construct(\StructType\Account $account = null, \ArrayType\ArrayOfOtherServiceInformation $otherServiceInformations = null)
    {
        $this
            ->setAccount($account)
            ->setOtherServiceInformations($otherServiceInformations);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Account|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Account $account
     * @return \StructType\AvailableCreditResponse
     */
    public function setAccount(\StructType\Account $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get OtherServiceInformations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOtherServiceInformation|null
     */
    public function getOtherServiceInformations()
    {
        return isset($this->OtherServiceInformations) ? $this->OtherServiceInformations : null;
    }
    /**
     * Set OtherServiceInformations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOtherServiceInformation $otherServiceInformations
     * @return \StructType\AvailableCreditResponse
     */
    public function setOtherServiceInformations(\ArrayType\ArrayOfOtherServiceInformation $otherServiceInformations = null)
    {
        if (is_null($otherServiceInformations) || (is_array($otherServiceInformations) && empty($otherServiceInformations))) {
            unset($this->OtherServiceInformations);
        } else {
            $this->OtherServiceInformations = $otherServiceInformations;
        }
        return $this;
    }
}
