<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountTransactionBatch StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountTransactionBatch
 * @subpackage Structs
 */
class AccountTransactionBatch extends StateMessage
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionType;
    /**
     * The TransactionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionCode;
    /**
     * The TransReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransReference;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The ForeignCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignCurrencyCode;
    /**
     * The ForeignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ForeignAmount;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The CreditExpiration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreditExpiration;
    /**
     * The AccountBatchID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountBatchID;
    /**
     * Constructor method for AccountTransactionBatch
     * @uses AccountTransactionBatch::setAccountID()
     * @uses AccountTransactionBatch::setTransactionType()
     * @uses AccountTransactionBatch::setTransactionCode()
     * @uses AccountTransactionBatch::setTransReference()
     * @uses AccountTransactionBatch::setCurrencyCode()
     * @uses AccountTransactionBatch::setAmount()
     * @uses AccountTransactionBatch::setForeignCurrencyCode()
     * @uses AccountTransactionBatch::setForeignAmount()
     * @uses AccountTransactionBatch::setNote()
     * @uses AccountTransactionBatch::setCreditExpiration()
     * @uses AccountTransactionBatch::setAccountBatchID()
     * @param int $accountID
     * @param string $transactionType
     * @param string $transactionCode
     * @param string $transReference
     * @param string $currencyCode
     * @param float $amount
     * @param string $foreignCurrencyCode
     * @param float $foreignAmount
     * @param string $note
     * @param string $creditExpiration
     * @param int $accountBatchID
     */
    public function __construct($accountID = null, $transactionType = null, $transactionCode = null, $transReference = null, $currencyCode = null, $amount = null, $foreignCurrencyCode = null, $foreignAmount = null, $note = null, $creditExpiration = null, $accountBatchID = null)
    {
        $this
            ->setAccountID($accountID)
            ->setTransactionType($transactionType)
            ->setTransactionCode($transactionCode)
            ->setTransReference($transReference)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setForeignCurrencyCode($foreignCurrencyCode)
            ->setForeignAmount($foreignAmount)
            ->setNote($note)
            ->setCreditExpiration($creditExpiration)
            ->setAccountBatchID($accountBatchID);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\AccountTransactionBatch
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @uses \EnumType\AccountTransactionType::valueIsValid()
     * @uses \EnumType\AccountTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\AccountTransactionBatch
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountTransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountTransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\AccountTransactionType::getValidValues())), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Get TransactionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionCode()
    {
        return isset($this->TransactionCode) ? $this->TransactionCode : null;
    }
    /**
     * Set TransactionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionCode
     * @return \StructType\AccountTransactionBatch
     */
    public function setTransactionCode($transactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionCode) && !is_string($transactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionCode, true), gettype($transactionCode)), __LINE__);
        }
        if (is_null($transactionCode) || (is_array($transactionCode) && empty($transactionCode))) {
            unset($this->TransactionCode);
        } else {
            $this->TransactionCode = $transactionCode;
        }
        return $this;
    }
    /**
     * Get TransReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransReference()
    {
        return isset($this->TransReference) ? $this->TransReference : null;
    }
    /**
     * Set TransReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transReference
     * @return \StructType\AccountTransactionBatch
     */
    public function setTransReference($transReference = null)
    {
        // validation for constraint: string
        if (!is_null($transReference) && !is_string($transReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transReference, true), gettype($transReference)), __LINE__);
        }
        if (is_null($transReference) || (is_array($transReference) && empty($transReference))) {
            unset($this->TransReference);
        } else {
            $this->TransReference = $transReference;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\AccountTransactionBatch
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AccountTransactionBatch
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ForeignCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignCurrencyCode()
    {
        return isset($this->ForeignCurrencyCode) ? $this->ForeignCurrencyCode : null;
    }
    /**
     * Set ForeignCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignCurrencyCode
     * @return \StructType\AccountTransactionBatch
     */
    public function setForeignCurrencyCode($foreignCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($foreignCurrencyCode) && !is_string($foreignCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignCurrencyCode, true), gettype($foreignCurrencyCode)), __LINE__);
        }
        if (is_null($foreignCurrencyCode) || (is_array($foreignCurrencyCode) && empty($foreignCurrencyCode))) {
            unset($this->ForeignCurrencyCode);
        } else {
            $this->ForeignCurrencyCode = $foreignCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ForeignAmount value
     * @return float|null
     */
    public function getForeignAmount()
    {
        return $this->ForeignAmount;
    }
    /**
     * Set ForeignAmount value
     * @param float $foreignAmount
     * @return \StructType\AccountTransactionBatch
     */
    public function setForeignAmount($foreignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($foreignAmount) && !(is_float($foreignAmount) || is_numeric($foreignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignAmount, true), gettype($foreignAmount)), __LINE__);
        }
        $this->ForeignAmount = $foreignAmount;
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\AccountTransactionBatch
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get CreditExpiration value
     * @return string|null
     */
    public function getCreditExpiration()
    {
        return $this->CreditExpiration;
    }
    /**
     * Set CreditExpiration value
     * @param string $creditExpiration
     * @return \StructType\AccountTransactionBatch
     */
    public function setCreditExpiration($creditExpiration = null)
    {
        // validation for constraint: string
        if (!is_null($creditExpiration) && !is_string($creditExpiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditExpiration, true), gettype($creditExpiration)), __LINE__);
        }
        $this->CreditExpiration = $creditExpiration;
        return $this;
    }
    /**
     * Get AccountBatchID value
     * @return int|null
     */
    public function getAccountBatchID()
    {
        return $this->AccountBatchID;
    }
    /**
     * Set AccountBatchID value
     * @param int $accountBatchID
     * @return \StructType\AccountTransactionBatch
     */
    public function setAccountBatchID($accountBatchID = null)
    {
        // validation for constraint: int
        if (!is_null($accountBatchID) && !(is_int($accountBatchID) || ctype_digit($accountBatchID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountBatchID, true), gettype($accountBatchID)), __LINE__);
        }
        $this->AccountBatchID = $accountBatchID;
        return $this;
    }
}
