<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountBatch StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountBatch
 * @subpackage Structs
 */
class AccountBatch extends ModifiedMessage
{
    /**
     * The AccountBatchID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountBatchID;
    /**
     * The AccountBatchReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountBatchReference;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The TransactionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TransactionCount;
    /**
     * The TransactionAmountTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TransactionAmountTotal;
    /**
     * The AccountTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountTransaction
     */
    public $AccountTransactions;
    /**
     * Constructor method for AccountBatch
     * @uses AccountBatch::setAccountBatchID()
     * @uses AccountBatch::setAccountBatchReference()
     * @uses AccountBatch::setNote()
     * @uses AccountBatch::setTransactionCount()
     * @uses AccountBatch::setTransactionAmountTotal()
     * @uses AccountBatch::setAccountTransactions()
     * @param int $accountBatchID
     * @param string $accountBatchReference
     * @param string $note
     * @param int $transactionCount
     * @param float $transactionAmountTotal
     * @param \ArrayType\ArrayOfAccountTransaction $accountTransactions
     */
    public function __construct($accountBatchID = null, $accountBatchReference = null, $note = null, $transactionCount = null, $transactionAmountTotal = null, \ArrayType\ArrayOfAccountTransaction $accountTransactions = null)
    {
        $this
            ->setAccountBatchID($accountBatchID)
            ->setAccountBatchReference($accountBatchReference)
            ->setNote($note)
            ->setTransactionCount($transactionCount)
            ->setTransactionAmountTotal($transactionAmountTotal)
            ->setAccountTransactions($accountTransactions);
    }
    /**
     * Get AccountBatchID value
     * @return int|null
     */
    public function getAccountBatchID()
    {
        return $this->AccountBatchID;
    }
    /**
     * Set AccountBatchID value
     * @param int $accountBatchID
     * @return \StructType\AccountBatch
     */
    public function setAccountBatchID($accountBatchID = null)
    {
        // validation for constraint: int
        if (!is_null($accountBatchID) && !(is_int($accountBatchID) || ctype_digit($accountBatchID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountBatchID, true), gettype($accountBatchID)), __LINE__);
        }
        $this->AccountBatchID = $accountBatchID;
        return $this;
    }
    /**
     * Get AccountBatchReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountBatchReference()
    {
        return isset($this->AccountBatchReference) ? $this->AccountBatchReference : null;
    }
    /**
     * Set AccountBatchReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountBatchReference
     * @return \StructType\AccountBatch
     */
    public function setAccountBatchReference($accountBatchReference = null)
    {
        // validation for constraint: string
        if (!is_null($accountBatchReference) && !is_string($accountBatchReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountBatchReference, true), gettype($accountBatchReference)), __LINE__);
        }
        if (is_null($accountBatchReference) || (is_array($accountBatchReference) && empty($accountBatchReference))) {
            unset($this->AccountBatchReference);
        } else {
            $this->AccountBatchReference = $accountBatchReference;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\AccountBatch
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get TransactionCount value
     * @return int|null
     */
    public function getTransactionCount()
    {
        return $this->TransactionCount;
    }
    /**
     * Set TransactionCount value
     * @param int $transactionCount
     * @return \StructType\AccountBatch
     */
    public function setTransactionCount($transactionCount = null)
    {
        // validation for constraint: int
        if (!is_null($transactionCount) && !(is_int($transactionCount) || ctype_digit($transactionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionCount, true), gettype($transactionCount)), __LINE__);
        }
        $this->TransactionCount = $transactionCount;
        return $this;
    }
    /**
     * Get TransactionAmountTotal value
     * @return float|null
     */
    public function getTransactionAmountTotal()
    {
        return $this->TransactionAmountTotal;
    }
    /**
     * Set TransactionAmountTotal value
     * @param float $transactionAmountTotal
     * @return \StructType\AccountBatch
     */
    public function setTransactionAmountTotal($transactionAmountTotal = null)
    {
        // validation for constraint: float
        if (!is_null($transactionAmountTotal) && !(is_float($transactionAmountTotal) || is_numeric($transactionAmountTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transactionAmountTotal, true), gettype($transactionAmountTotal)), __LINE__);
        }
        $this->TransactionAmountTotal = $transactionAmountTotal;
        return $this;
    }
    /**
     * Get AccountTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountTransaction|null
     */
    public function getAccountTransactions()
    {
        return isset($this->AccountTransactions) ? $this->AccountTransactions : null;
    }
    /**
     * Set AccountTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountTransaction $accountTransactions
     * @return \StructType\AccountBatch
     */
    public function setAccountTransactions(\ArrayType\ArrayOfAccountTransaction $accountTransactions = null)
    {
        if (is_null($accountTransactions) || (is_array($accountTransactions) && empty($accountTransactions))) {
            unset($this->AccountTransactions);
        } else {
            $this->AccountTransactions = $accountTransactions;
        }
        return $this;
    }
}
