<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Sets the ContractVersion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $contractVersion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContractVersion($contractVersion, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ContractVersion', $contractVersion, $mustUnderstand, $actor);
    }
    /**
     * Sets the EnableExceptionStackTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $enableExceptionStackTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEnableExceptionStackTrace($enableExceptionStackTrace, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EnableExceptionStackTrace', $enableExceptionStackTrace, $mustUnderstand, $actor);
    }
    /**
     * Sets the MessageContractVersion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $messageContractVersion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageContractVersion($messageContractVersion, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageContractVersion', $messageContractVersion, $mustUnderstand, $actor);
    }
    /**
     * Sets the Signature SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $signature
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSignature($signature, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Signature', $signature, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named FindAccountTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindAccountTransactionRequest $parameters
     * @return \StructType\FindAccountTransactionResponse|bool
     */
    public function FindAccountTransactions(\StructType\FindAccountTransactionRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->FindAccountTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindAccountTransactionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
