<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOtherServiceInformation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOtherServiceInformation
 * @subpackage Arrays
 */
class ArrayOfOtherServiceInformation extends AbstractStructArrayBase
{
    /**
     * The OtherServiceInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OtherServiceInformation[]
     */
    public $OtherServiceInformation;
    /**
     * Constructor method for ArrayOfOtherServiceInformation
     * @uses ArrayOfOtherServiceInformation::setOtherServiceInformation()
     * @param \StructType\OtherServiceInformation[] $otherServiceInformation
     */
    public function __construct(array $otherServiceInformation = array())
    {
        $this
            ->setOtherServiceInformation($otherServiceInformation);
    }
    /**
     * Get OtherServiceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OtherServiceInformation[]|null
     */
    public function getOtherServiceInformation()
    {
        return isset($this->OtherServiceInformation) ? $this->OtherServiceInformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOtherServiceInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOtherServiceInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOtherServiceInformationForArrayConstraintsFromSetOtherServiceInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOtherServiceInformationOtherServiceInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfOtherServiceInformationOtherServiceInformationItem instanceof \StructType\OtherServiceInformation) {
                $invalidValues[] = is_object($arrayOfOtherServiceInformationOtherServiceInformationItem) ? get_class($arrayOfOtherServiceInformationOtherServiceInformationItem) : sprintf('%s(%s)', gettype($arrayOfOtherServiceInformationOtherServiceInformationItem), var_export($arrayOfOtherServiceInformationOtherServiceInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OtherServiceInformation property can only contain items of type \StructType\OtherServiceInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OtherServiceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OtherServiceInformation[] $otherServiceInformation
     * @return \ArrayType\ArrayOfOtherServiceInformation
     */
    public function setOtherServiceInformation(array $otherServiceInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($otherServiceInformationArrayErrorMessage = self::validateOtherServiceInformationForArrayConstraintsFromSetOtherServiceInformation($otherServiceInformation))) {
            throw new \InvalidArgumentException($otherServiceInformationArrayErrorMessage, __LINE__);
        }
        if (is_null($otherServiceInformation) || (is_array($otherServiceInformation) && empty($otherServiceInformation))) {
            unset($this->OtherServiceInformation);
        } else {
            $this->OtherServiceInformation = $otherServiceInformation;
        }
        return $this;
    }
    /**
     * Add item to OtherServiceInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\OtherServiceInformation $item
     * @return \ArrayType\ArrayOfOtherServiceInformation
     */
    public function addToOtherServiceInformation(\StructType\OtherServiceInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OtherServiceInformation) {
            throw new \InvalidArgumentException(sprintf('The OtherServiceInformation property can only contain items of type \StructType\OtherServiceInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OtherServiceInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OtherServiceInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OtherServiceInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OtherServiceInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OtherServiceInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OtherServiceInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OtherServiceInformation
     */
    public function getAttributeName()
    {
        return 'OtherServiceInformation';
    }
}
