<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountTransaction ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAccountTransaction
 * @subpackage Arrays
 */
class ArrayOfAccountTransaction extends AbstractStructArrayBase
{
    /**
     * The AccountTransaction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountTransaction[]
     */
    public $AccountTransaction;
    /**
     * Constructor method for ArrayOfAccountTransaction
     * @uses ArrayOfAccountTransaction::setAccountTransaction()
     * @param \StructType\AccountTransaction[] $accountTransaction
     */
    public function __construct(array $accountTransaction = array())
    {
        $this
            ->setAccountTransaction($accountTransaction);
    }
    /**
     * Get AccountTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountTransaction[]|null
     */
    public function getAccountTransaction()
    {
        return isset($this->AccountTransaction) ? $this->AccountTransaction : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountTransaction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountTransaction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountTransactionForArrayConstraintsFromSetAccountTransaction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfAccountTransactionAccountTransactionItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountTransactionAccountTransactionItem instanceof \StructType\AccountTransaction) {
                $invalidValues[] = is_object($arrayOfAccountTransactionAccountTransactionItem) ? get_class($arrayOfAccountTransactionAccountTransactionItem) : sprintf('%s(%s)', gettype($arrayOfAccountTransactionAccountTransactionItem), var_export($arrayOfAccountTransactionAccountTransactionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountTransaction property can only contain items of type \StructType\AccountTransaction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountTransaction[] $accountTransaction
     * @return \ArrayType\ArrayOfAccountTransaction
     */
    public function setAccountTransaction(array $accountTransaction = array())
    {
        // validation for constraint: array
        if ('' !== ($accountTransactionArrayErrorMessage = self::validateAccountTransactionForArrayConstraintsFromSetAccountTransaction($accountTransaction))) {
            throw new \InvalidArgumentException($accountTransactionArrayErrorMessage, __LINE__);
        }
        if (is_null($accountTransaction) || (is_array($accountTransaction) && empty($accountTransaction))) {
            unset($this->AccountTransaction);
        } else {
            $this->AccountTransaction = $accountTransaction;
        }
        return $this;
    }
    /**
     * Add item to AccountTransaction value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountTransaction $item
     * @return \ArrayType\ArrayOfAccountTransaction
     */
    public function addToAccountTransaction(\StructType\AccountTransaction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountTransaction) {
            throw new \InvalidArgumentException(sprintf('The AccountTransaction property can only contain items of type \StructType\AccountTransaction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AccountTransaction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountTransaction|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountTransaction|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountTransaction|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountTransaction|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountTransaction|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountTransaction
     */
    public function getAttributeName()
    {
        return 'AccountTransaction';
    }
}
