<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Commit ServiceType
 */
$commit = new \ServiceType\Commit($options);
$commit->setSoapHeaderContractVersion($ContractVersion);
$commit->setSoapHeaderEnableExceptionStackTrace($EnableExceptionStackTrace);
$commit->setSoapHeaderMessageContractVersion($MessageContractVersion);
$commit->setSoapHeaderSignature($Signature);
/**
 * Sample call for CommitAccount operation/method
 */
if ($commit->CommitAccount(new \StructType\CommitAccountRequest()) !== false) {
    print_r($commit->getResult());
} else {
    print_r($commit->getLastError());
}
/**
 * Sample call for CommitAccountTransactions operation/method
 */
if ($commit->CommitAccountTransactions(new \StructType\CommitAccountTransactionsRequest()) !== false) {
    print_r($commit->getResult());
} else {
    print_r($commit->getLastError());
}
/**
 * Sample call for CommitAccountBatch operation/method
 */
if ($commit->CommitAccountBatch(new \StructType\CommitAccountBatchRequest()) !== false) {
    print_r($commit->getResult());
} else {
    print_r($commit->getLastError());
}
/**
 * Sample call for CommitAccountTransactionBatchEntry operation/method
 */
if ($commit->CommitAccountTransactionBatchEntry(new \StructType\CommitAccountTransactionsBatchRequest()) !== false) {
    print_r($commit->getResult());
} else {
    print_r($commit->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
$find->setSoapHeaderContractVersion($ContractVersion);
$find->setSoapHeaderEnableExceptionStackTrace($EnableExceptionStackTrace);
$find->setSoapHeaderMessageContractVersion($MessageContractVersion);
$find->setSoapHeaderSignature($Signature);
/**
 * Sample call for FindAccountTransactions operation/method
 */
if ($find->FindAccountTransactions(new \StructType\FindAccountTransactionRequest()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderContractVersion($ContractVersion);
$get->setSoapHeaderEnableExceptionStackTrace($EnableExceptionStackTrace);
$get->setSoapHeaderMessageContractVersion($MessageContractVersion);
$get->setSoapHeaderSignature($Signature);
/**
 * Sample call for GetAccount operation/method
 */
if ($get->GetAccount(new \StructType\GetAccountRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountByReference operation/method
 */
if ($get->GetAccountByReference(new \StructType\GetAccountByReferenceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableCreditByReference operation/method
 */
if ($get->GetAvailableCreditByReference(new \StructType\GetAvailableCreditByReferenceRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
