<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherTransaction StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VoucherTransaction
 * @subpackage Structs
 */
class VoucherTransaction extends ModifiedMessage
{
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherID;
    /**
     * The VoucherTransactionID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherTransactionID;
    /**
     * The VoucherTransactionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VoucherTransactionType;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ForeignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ForeignAmount;
    /**
     * The ForeignCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignCurrencyCode;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * Constructor method for VoucherTransaction
     * @uses VoucherTransaction::setVoucherID()
     * @uses VoucherTransaction::setVoucherTransactionID()
     * @uses VoucherTransaction::setVoucherTransactionType()
     * @uses VoucherTransaction::setAmount()
     * @uses VoucherTransaction::setCurrencyCode()
     * @uses VoucherTransaction::setForeignAmount()
     * @uses VoucherTransaction::setForeignCurrencyCode()
     * @uses VoucherTransaction::setRecordLocator()
     * @param int $voucherID
     * @param int $voucherTransactionID
     * @param string $voucherTransactionType
     * @param float $amount
     * @param string $currencyCode
     * @param float $foreignAmount
     * @param string $foreignCurrencyCode
     * @param string $recordLocator
     */
    public function __construct($voucherID = null, $voucherTransactionID = null, $voucherTransactionType = null, $amount = null, $currencyCode = null, $foreignAmount = null, $foreignCurrencyCode = null, $recordLocator = null)
    {
        $this
            ->setVoucherID($voucherID)
            ->setVoucherTransactionID($voucherTransactionID)
            ->setVoucherTransactionType($voucherTransactionType)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setForeignAmount($foreignAmount)
            ->setForeignCurrencyCode($foreignCurrencyCode)
            ->setRecordLocator($recordLocator);
    }
    /**
     * Get VoucherID value
     * @return int|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param int $voucherID
     * @return \StructType\VoucherTransaction
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: int
        if (!is_null($voucherID) && !(is_int($voucherID) || ctype_digit($voucherID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
    /**
     * Get VoucherTransactionID value
     * @return int|null
     */
    public function getVoucherTransactionID()
    {
        return $this->VoucherTransactionID;
    }
    /**
     * Set VoucherTransactionID value
     * @param int $voucherTransactionID
     * @return \StructType\VoucherTransaction
     */
    public function setVoucherTransactionID($voucherTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($voucherTransactionID) && !(is_int($voucherTransactionID) || ctype_digit($voucherTransactionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherTransactionID, true), gettype($voucherTransactionID)), __LINE__);
        }
        $this->VoucherTransactionID = $voucherTransactionID;
        return $this;
    }
    /**
     * Get VoucherTransactionType value
     * @return string|null
     */
    public function getVoucherTransactionType()
    {
        return $this->VoucherTransactionType;
    }
    /**
     * Set VoucherTransactionType value
     * @uses \EnumType\VoucherTransactionType::valueIsValid()
     * @uses \EnumType\VoucherTransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $voucherTransactionType
     * @return \StructType\VoucherTransaction
     */
    public function setVoucherTransactionType($voucherTransactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherTransactionType::valueIsValid($voucherTransactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VoucherTransactionType', is_array($voucherTransactionType) ? implode(', ', $voucherTransactionType) : var_export($voucherTransactionType, true), implode(', ', \EnumType\VoucherTransactionType::getValidValues())), __LINE__);
        }
        $this->VoucherTransactionType = $voucherTransactionType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\VoucherTransaction
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\VoucherTransaction
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ForeignAmount value
     * @return float|null
     */
    public function getForeignAmount()
    {
        return $this->ForeignAmount;
    }
    /**
     * Set ForeignAmount value
     * @param float $foreignAmount
     * @return \StructType\VoucherTransaction
     */
    public function setForeignAmount($foreignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($foreignAmount) && !(is_float($foreignAmount) || is_numeric($foreignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignAmount, true), gettype($foreignAmount)), __LINE__);
        }
        $this->ForeignAmount = $foreignAmount;
        return $this;
    }
    /**
     * Get ForeignCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignCurrencyCode()
    {
        return isset($this->ForeignCurrencyCode) ? $this->ForeignCurrencyCode : null;
    }
    /**
     * Set ForeignCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignCurrencyCode
     * @return \StructType\VoucherTransaction
     */
    public function setForeignCurrencyCode($foreignCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($foreignCurrencyCode) && !is_string($foreignCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignCurrencyCode, true), gettype($foreignCurrencyCode)), __LINE__);
        }
        if (is_null($foreignCurrencyCode) || (is_array($foreignCurrencyCode) && empty($foreignCurrencyCode))) {
            unset($this->ForeignCurrencyCode);
        } else {
            $this->ForeignCurrencyCode = $foreignCurrencyCode;
        }
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\VoucherTransaction
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
}
