<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherIssuance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VoucherIssuance
 * @subpackage Structs
 */
class VoucherIssuance extends ModifiedMessage
{
    /**
     * The VoucherBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherBasisCode;
    /**
     * The VoucherIssuanceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherIssuanceID;
    /**
     * The IssuanceReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuanceReasonCode;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The InventorySegmentKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InventorySegmentKey;
    /**
     * The Vouchers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVoucher
     */
    public $Vouchers;
    /**
     * Constructor method for VoucherIssuance
     * @uses VoucherIssuance::setVoucherBasisCode()
     * @uses VoucherIssuance::setVoucherIssuanceID()
     * @uses VoucherIssuance::setIssuanceReasonCode()
     * @uses VoucherIssuance::setNote()
     * @uses VoucherIssuance::setCurrencyCode()
     * @uses VoucherIssuance::setAmount()
     * @uses VoucherIssuance::setExpirationDate()
     * @uses VoucherIssuance::setInventorySegmentKey()
     * @uses VoucherIssuance::setVouchers()
     * @param string $voucherBasisCode
     * @param int $voucherIssuanceID
     * @param string $issuanceReasonCode
     * @param string $note
     * @param string $currencyCode
     * @param float $amount
     * @param string $expirationDate
     * @param string $inventorySegmentKey
     * @param \ArrayType\ArrayOfVoucher $vouchers
     */
    public function __construct($voucherBasisCode = null, $voucherIssuanceID = null, $issuanceReasonCode = null, $note = null, $currencyCode = null, $amount = null, $expirationDate = null, $inventorySegmentKey = null, \ArrayType\ArrayOfVoucher $vouchers = null)
    {
        $this
            ->setVoucherBasisCode($voucherBasisCode)
            ->setVoucherIssuanceID($voucherIssuanceID)
            ->setIssuanceReasonCode($issuanceReasonCode)
            ->setNote($note)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setExpirationDate($expirationDate)
            ->setInventorySegmentKey($inventorySegmentKey)
            ->setVouchers($vouchers);
    }
    /**
     * Get VoucherBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherBasisCode()
    {
        return isset($this->VoucherBasisCode) ? $this->VoucherBasisCode : null;
    }
    /**
     * Set VoucherBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherBasisCode
     * @return \StructType\VoucherIssuance
     */
    public function setVoucherBasisCode($voucherBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($voucherBasisCode) && !is_string($voucherBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherBasisCode, true), gettype($voucherBasisCode)), __LINE__);
        }
        if (is_null($voucherBasisCode) || (is_array($voucherBasisCode) && empty($voucherBasisCode))) {
            unset($this->VoucherBasisCode);
        } else {
            $this->VoucherBasisCode = $voucherBasisCode;
        }
        return $this;
    }
    /**
     * Get VoucherIssuanceID value
     * @return int|null
     */
    public function getVoucherIssuanceID()
    {
        return $this->VoucherIssuanceID;
    }
    /**
     * Set VoucherIssuanceID value
     * @param int $voucherIssuanceID
     * @return \StructType\VoucherIssuance
     */
    public function setVoucherIssuanceID($voucherIssuanceID = null)
    {
        // validation for constraint: int
        if (!is_null($voucherIssuanceID) && !(is_int($voucherIssuanceID) || ctype_digit($voucherIssuanceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherIssuanceID, true), gettype($voucherIssuanceID)), __LINE__);
        }
        $this->VoucherIssuanceID = $voucherIssuanceID;
        return $this;
    }
    /**
     * Get IssuanceReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuanceReasonCode()
    {
        return isset($this->IssuanceReasonCode) ? $this->IssuanceReasonCode : null;
    }
    /**
     * Set IssuanceReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuanceReasonCode
     * @return \StructType\VoucherIssuance
     */
    public function setIssuanceReasonCode($issuanceReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuanceReasonCode) && !is_string($issuanceReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuanceReasonCode, true), gettype($issuanceReasonCode)), __LINE__);
        }
        if (is_null($issuanceReasonCode) || (is_array($issuanceReasonCode) && empty($issuanceReasonCode))) {
            unset($this->IssuanceReasonCode);
        } else {
            $this->IssuanceReasonCode = $issuanceReasonCode;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\VoucherIssuance
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\VoucherIssuance
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\VoucherIssuance
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\VoucherIssuance
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get InventorySegmentKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventorySegmentKey()
    {
        return isset($this->InventorySegmentKey) ? $this->InventorySegmentKey : null;
    }
    /**
     * Set InventorySegmentKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventorySegmentKey
     * @return \StructType\VoucherIssuance
     */
    public function setInventorySegmentKey($inventorySegmentKey = null)
    {
        // validation for constraint: string
        if (!is_null($inventorySegmentKey) && !is_string($inventorySegmentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventorySegmentKey, true), gettype($inventorySegmentKey)), __LINE__);
        }
        if (is_null($inventorySegmentKey) || (is_array($inventorySegmentKey) && empty($inventorySegmentKey))) {
            unset($this->InventorySegmentKey);
        } else {
            $this->InventorySegmentKey = $inventorySegmentKey;
        }
        return $this;
    }
    /**
     * Get Vouchers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVoucher|null
     */
    public function getVouchers()
    {
        return isset($this->Vouchers) ? $this->Vouchers : null;
    }
    /**
     * Set Vouchers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVoucher $vouchers
     * @return \StructType\VoucherIssuance
     */
    public function setVouchers(\ArrayType\ArrayOfVoucher $vouchers = null)
    {
        if (is_null($vouchers) || (is_array($vouchers) && empty($vouchers))) {
            unset($this->Vouchers);
        } else {
            $this->Vouchers = $vouchers;
        }
        return $this;
    }
}
