<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Voucher
 * @subpackage Structs
 */
class Voucher extends ModifiedMessage
{
    /**
     * The VoucherID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherID;
    /**
     * The VoucherType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VoucherType;
    /**
     * The VoucherBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherBasisCode;
    /**
     * The VoucherIssuanceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VoucherIssuanceID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The VoucherReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VoucherReference;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Available;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ForeignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ForeignAmount;
    /**
     * The ForeignCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignCurrencyCode;
    /**
     * The Expiration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Expiration;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The PersonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonID;
    /**
     * The VoucherTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVoucherTransaction
     */
    public $VoucherTransactions;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setVoucherID()
     * @uses Voucher::setVoucherType()
     * @uses Voucher::setVoucherBasisCode()
     * @uses Voucher::setVoucherIssuanceID()
     * @uses Voucher::setStatus()
     * @uses Voucher::setVoucherReference()
     * @uses Voucher::setPassword()
     * @uses Voucher::setAmount()
     * @uses Voucher::setAvailable()
     * @uses Voucher::setCurrencyCode()
     * @uses Voucher::setForeignAmount()
     * @uses Voucher::setForeignCurrencyCode()
     * @uses Voucher::setExpiration()
     * @uses Voucher::setRecordLocator()
     * @uses Voucher::setLastName()
     * @uses Voucher::setFirstName()
     * @uses Voucher::setPersonID()
     * @uses Voucher::setVoucherTransactions()
     * @param int $voucherID
     * @param string $voucherType
     * @param string $voucherBasisCode
     * @param int $voucherIssuanceID
     * @param string $status
     * @param string $voucherReference
     * @param string $password
     * @param float $amount
     * @param float $available
     * @param string $currencyCode
     * @param float $foreignAmount
     * @param string $foreignCurrencyCode
     * @param string $expiration
     * @param string $recordLocator
     * @param string $lastName
     * @param string $firstName
     * @param int $personID
     * @param \ArrayType\ArrayOfVoucherTransaction $voucherTransactions
     */
    public function __construct($voucherID = null, $voucherType = null, $voucherBasisCode = null, $voucherIssuanceID = null, $status = null, $voucherReference = null, $password = null, $amount = null, $available = null, $currencyCode = null, $foreignAmount = null, $foreignCurrencyCode = null, $expiration = null, $recordLocator = null, $lastName = null, $firstName = null, $personID = null, \ArrayType\ArrayOfVoucherTransaction $voucherTransactions = null)
    {
        $this
            ->setVoucherID($voucherID)
            ->setVoucherType($voucherType)
            ->setVoucherBasisCode($voucherBasisCode)
            ->setVoucherIssuanceID($voucherIssuanceID)
            ->setStatus($status)
            ->setVoucherReference($voucherReference)
            ->setPassword($password)
            ->setAmount($amount)
            ->setAvailable($available)
            ->setCurrencyCode($currencyCode)
            ->setForeignAmount($foreignAmount)
            ->setForeignCurrencyCode($foreignCurrencyCode)
            ->setExpiration($expiration)
            ->setRecordLocator($recordLocator)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setPersonID($personID)
            ->setVoucherTransactions($voucherTransactions);
    }
    /**
     * Get VoucherID value
     * @return int|null
     */
    public function getVoucherID()
    {
        return $this->VoucherID;
    }
    /**
     * Set VoucherID value
     * @param int $voucherID
     * @return \StructType\Voucher
     */
    public function setVoucherID($voucherID = null)
    {
        // validation for constraint: int
        if (!is_null($voucherID) && !(is_int($voucherID) || ctype_digit($voucherID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherID, true), gettype($voucherID)), __LINE__);
        }
        $this->VoucherID = $voucherID;
        return $this;
    }
    /**
     * Get VoucherType value
     * @return string|null
     */
    public function getVoucherType()
    {
        return $this->VoucherType;
    }
    /**
     * Set VoucherType value
     * @uses \EnumType\VoucherType::valueIsValid()
     * @uses \EnumType\VoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $voucherType
     * @return \StructType\Voucher
     */
    public function setVoucherType($voucherType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherType::valueIsValid($voucherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VoucherType', is_array($voucherType) ? implode(', ', $voucherType) : var_export($voucherType, true), implode(', ', \EnumType\VoucherType::getValidValues())), __LINE__);
        }
        $this->VoucherType = $voucherType;
        return $this;
    }
    /**
     * Get VoucherBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherBasisCode()
    {
        return isset($this->VoucherBasisCode) ? $this->VoucherBasisCode : null;
    }
    /**
     * Set VoucherBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherBasisCode
     * @return \StructType\Voucher
     */
    public function setVoucherBasisCode($voucherBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($voucherBasisCode) && !is_string($voucherBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherBasisCode, true), gettype($voucherBasisCode)), __LINE__);
        }
        if (is_null($voucherBasisCode) || (is_array($voucherBasisCode) && empty($voucherBasisCode))) {
            unset($this->VoucherBasisCode);
        } else {
            $this->VoucherBasisCode = $voucherBasisCode;
        }
        return $this;
    }
    /**
     * Get VoucherIssuanceID value
     * @return int|null
     */
    public function getVoucherIssuanceID()
    {
        return $this->VoucherIssuanceID;
    }
    /**
     * Set VoucherIssuanceID value
     * @param int $voucherIssuanceID
     * @return \StructType\Voucher
     */
    public function setVoucherIssuanceID($voucherIssuanceID = null)
    {
        // validation for constraint: int
        if (!is_null($voucherIssuanceID) && !(is_int($voucherIssuanceID) || ctype_digit($voucherIssuanceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherIssuanceID, true), gettype($voucherIssuanceID)), __LINE__);
        }
        $this->VoucherIssuanceID = $voucherIssuanceID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\VoucherStatus::valueIsValid()
     * @uses \EnumType\VoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Voucher
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VoucherStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\VoucherStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get VoucherReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoucherReference()
    {
        return isset($this->VoucherReference) ? $this->VoucherReference : null;
    }
    /**
     * Set VoucherReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voucherReference
     * @return \StructType\Voucher
     */
    public function setVoucherReference($voucherReference = null)
    {
        // validation for constraint: string
        if (!is_null($voucherReference) && !is_string($voucherReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherReference, true), gettype($voucherReference)), __LINE__);
        }
        if (is_null($voucherReference) || (is_array($voucherReference) && empty($voucherReference))) {
            unset($this->VoucherReference);
        } else {
            $this->VoucherReference = $voucherReference;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\Voucher
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Voucher
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Available value
     * @return float|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param float $available
     * @return \StructType\Voucher
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: float
        if (!is_null($available) && !(is_float($available) || is_numeric($available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\Voucher
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ForeignAmount value
     * @return float|null
     */
    public function getForeignAmount()
    {
        return $this->ForeignAmount;
    }
    /**
     * Set ForeignAmount value
     * @param float $foreignAmount
     * @return \StructType\Voucher
     */
    public function setForeignAmount($foreignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($foreignAmount) && !(is_float($foreignAmount) || is_numeric($foreignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignAmount, true), gettype($foreignAmount)), __LINE__);
        }
        $this->ForeignAmount = $foreignAmount;
        return $this;
    }
    /**
     * Get ForeignCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignCurrencyCode()
    {
        return isset($this->ForeignCurrencyCode) ? $this->ForeignCurrencyCode : null;
    }
    /**
     * Set ForeignCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignCurrencyCode
     * @return \StructType\Voucher
     */
    public function setForeignCurrencyCode($foreignCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($foreignCurrencyCode) && !is_string($foreignCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignCurrencyCode, true), gettype($foreignCurrencyCode)), __LINE__);
        }
        if (is_null($foreignCurrencyCode) || (is_array($foreignCurrencyCode) && empty($foreignCurrencyCode))) {
            unset($this->ForeignCurrencyCode);
        } else {
            $this->ForeignCurrencyCode = $foreignCurrencyCode;
        }
        return $this;
    }
    /**
     * Get Expiration value
     * @return string|null
     */
    public function getExpiration()
    {
        return $this->Expiration;
    }
    /**
     * Set Expiration value
     * @param string $expiration
     * @return \StructType\Voucher
     */
    public function setExpiration($expiration = null)
    {
        // validation for constraint: string
        if (!is_null($expiration) && !is_string($expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration, true), gettype($expiration)), __LINE__);
        }
        $this->Expiration = $expiration;
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\Voucher
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Voucher
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Voucher
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get PersonID value
     * @return int|null
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \StructType\Voucher
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !(is_int($personID) || ctype_digit($personID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get VoucherTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVoucherTransaction|null
     */
    public function getVoucherTransactions()
    {
        return isset($this->VoucherTransactions) ? $this->VoucherTransactions : null;
    }
    /**
     * Set VoucherTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVoucherTransaction $voucherTransactions
     * @return \StructType\Voucher
     */
    public function setVoucherTransactions(\ArrayType\ArrayOfVoucherTransaction $voucherTransactions = null)
    {
        if (is_null($voucherTransactions) || (is_array($voucherTransactions) && empty($voucherTransactions))) {
            unset($this->VoucherTransactions);
        } else {
            $this->VoucherTransactions = $voucherTransactions;
        }
        return $this;
    }
}
