<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostAccountTransactionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PostAccountTransactionRequest
 * @subpackage Structs
 */
class PostAccountTransactionRequest extends AccountTransactionMessage
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountTransactionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountTransactionCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for PostAccountTransactionRequest
     * @uses PostAccountTransactionRequest::setAccountID()
     * @uses PostAccountTransactionRequest::setAccountTransactionCode()
     * @uses PostAccountTransactionRequest::setAmount()
     * @uses PostAccountTransactionRequest::setCurrencyCode()
     * @param int $accountID
     * @param string $accountTransactionCode
     * @param float $amount
     * @param string $currencyCode
     */
    public function __construct($accountID = null, $accountTransactionCode = null, $amount = null, $currencyCode = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountTransactionCode($accountTransactionCode)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\PostAccountTransactionRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountTransactionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountTransactionCode()
    {
        return isset($this->AccountTransactionCode) ? $this->AccountTransactionCode : null;
    }
    /**
     * Set AccountTransactionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountTransactionCode
     * @return \StructType\PostAccountTransactionRequest
     */
    public function setAccountTransactionCode($accountTransactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountTransactionCode) && !is_string($accountTransactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTransactionCode, true), gettype($accountTransactionCode)), __LINE__);
        }
        if (is_null($accountTransactionCode) || (is_array($accountTransactionCode) && empty($accountTransactionCode))) {
            unset($this->AccountTransactionCode);
        } else {
            $this->AccountTransactionCode = $accountTransactionCode;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\PostAccountTransactionRequest
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\PostAccountTransactionRequest
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
}
