<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountCredit StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountCredit
 * @subpackage Structs
 */
class AccountCredit extends ModifiedMessage
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountCreditID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountCreditID;
    /**
     * The AccountTransactionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountTransactionCode;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Available;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Expiration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Expiration;
    /**
     * The AccountTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountTransaction
     */
    public $AccountTransactions;
    /**
     * The SpoiledAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SpoiledAmount;
    /**
     * Constructor method for AccountCredit
     * @uses AccountCredit::setAccountID()
     * @uses AccountCredit::setAccountCreditID()
     * @uses AccountCredit::setAccountTransactionCode()
     * @uses AccountCredit::setAmount()
     * @uses AccountCredit::setAvailable()
     * @uses AccountCredit::setCurrencyCode()
     * @uses AccountCredit::setExpiration()
     * @uses AccountCredit::setAccountTransactions()
     * @uses AccountCredit::setSpoiledAmount()
     * @param int $accountID
     * @param int $accountCreditID
     * @param string $accountTransactionCode
     * @param float $amount
     * @param float $available
     * @param string $currencyCode
     * @param string $expiration
     * @param \ArrayType\ArrayOfAccountTransaction $accountTransactions
     * @param float $spoiledAmount
     */
    public function __construct($accountID = null, $accountCreditID = null, $accountTransactionCode = null, $amount = null, $available = null, $currencyCode = null, $expiration = null, \ArrayType\ArrayOfAccountTransaction $accountTransactions = null, $spoiledAmount = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountCreditID($accountCreditID)
            ->setAccountTransactionCode($accountTransactionCode)
            ->setAmount($amount)
            ->setAvailable($available)
            ->setCurrencyCode($currencyCode)
            ->setExpiration($expiration)
            ->setAccountTransactions($accountTransactions)
            ->setSpoiledAmount($spoiledAmount);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\AccountCredit
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountCreditID value
     * @return int|null
     */
    public function getAccountCreditID()
    {
        return $this->AccountCreditID;
    }
    /**
     * Set AccountCreditID value
     * @param int $accountCreditID
     * @return \StructType\AccountCredit
     */
    public function setAccountCreditID($accountCreditID = null)
    {
        // validation for constraint: int
        if (!is_null($accountCreditID) && !(is_int($accountCreditID) || ctype_digit($accountCreditID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountCreditID, true), gettype($accountCreditID)), __LINE__);
        }
        $this->AccountCreditID = $accountCreditID;
        return $this;
    }
    /**
     * Get AccountTransactionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountTransactionCode()
    {
        return isset($this->AccountTransactionCode) ? $this->AccountTransactionCode : null;
    }
    /**
     * Set AccountTransactionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountTransactionCode
     * @return \StructType\AccountCredit
     */
    public function setAccountTransactionCode($accountTransactionCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountTransactionCode) && !is_string($accountTransactionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountTransactionCode, true), gettype($accountTransactionCode)), __LINE__);
        }
        if (is_null($accountTransactionCode) || (is_array($accountTransactionCode) && empty($accountTransactionCode))) {
            unset($this->AccountTransactionCode);
        } else {
            $this->AccountTransactionCode = $accountTransactionCode;
        }
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AccountCredit
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Available value
     * @return float|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param float $available
     * @return \StructType\AccountCredit
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: float
        if (!is_null($available) && !(is_float($available) || is_numeric($available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\AccountCredit
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get Expiration value
     * @return string|null
     */
    public function getExpiration()
    {
        return $this->Expiration;
    }
    /**
     * Set Expiration value
     * @param string $expiration
     * @return \StructType\AccountCredit
     */
    public function setExpiration($expiration = null)
    {
        // validation for constraint: string
        if (!is_null($expiration) && !is_string($expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration, true), gettype($expiration)), __LINE__);
        }
        $this->Expiration = $expiration;
        return $this;
    }
    /**
     * Get AccountTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountTransaction|null
     */
    public function getAccountTransactions()
    {
        return isset($this->AccountTransactions) ? $this->AccountTransactions : null;
    }
    /**
     * Set AccountTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountTransaction $accountTransactions
     * @return \StructType\AccountCredit
     */
    public function setAccountTransactions(\ArrayType\ArrayOfAccountTransaction $accountTransactions = null)
    {
        if (is_null($accountTransactions) || (is_array($accountTransactions) && empty($accountTransactions))) {
            unset($this->AccountTransactions);
        } else {
            $this->AccountTransactions = $accountTransactions;
        }
        return $this;
    }
    /**
     * Get SpoiledAmount value
     * @return float|null
     */
    public function getSpoiledAmount()
    {
        return $this->SpoiledAmount;
    }
    /**
     * Set SpoiledAmount value
     * @param float $spoiledAmount
     * @return \StructType\AccountCredit
     */
    public function setSpoiledAmount($spoiledAmount = null)
    {
        // validation for constraint: float
        if (!is_null($spoiledAmount) && !(is_float($spoiledAmount) || is_numeric($spoiledAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spoiledAmount, true), gettype($spoiledAmount)), __LINE__);
        }
        $this->SpoiledAmount = $spoiledAmount;
        return $this;
    }
}
