<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Account StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Account
 * @subpackage Structs
 */
class Account extends ModifiedMessage
{
    /**
     * The AccountID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccountID;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The AccountHolderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolderType;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The AccountReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountReference;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Limit;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PersonID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonID;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonName;
    /**
     * The ForeignCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForeignCurrencyCode;
    /**
     * The ForeignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ForeignAmount;
    /**
     * The AccountCredits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountCredit
     */
    public $AccountCredits;
    /**
     * The AvailableCredits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AvailableCredits;
    /**
     * The SpoiledCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpoiledCurrencyCode;
    /**
     * The SpoiledForeignAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SpoiledForeignAmount;
    /**
     * Constructor method for Account
     * @uses Account::setAccountID()
     * @uses Account::setAccountType()
     * @uses Account::setAccountHolderType()
     * @uses Account::setStatus()
     * @uses Account::setAccountReference()
     * @uses Account::setPassword()
     * @uses Account::setLimit()
     * @uses Account::setCurrencyCode()
     * @uses Account::setPersonID()
     * @uses Account::setPersonName()
     * @uses Account::setForeignCurrencyCode()
     * @uses Account::setForeignAmount()
     * @uses Account::setAccountCredits()
     * @uses Account::setAvailableCredits()
     * @uses Account::setSpoiledCurrencyCode()
     * @uses Account::setSpoiledForeignAmount()
     * @param int $accountID
     * @param string $accountType
     * @param string $accountHolderType
     * @param string $status
     * @param string $accountReference
     * @param string $password
     * @param float $limit
     * @param string $currencyCode
     * @param int $personID
     * @param string $personName
     * @param string $foreignCurrencyCode
     * @param float $foreignAmount
     * @param \ArrayType\ArrayOfAccountCredit $accountCredits
     * @param float $availableCredits
     * @param string $spoiledCurrencyCode
     * @param float $spoiledForeignAmount
     */
    public function __construct($accountID = null, $accountType = null, $accountHolderType = null, $status = null, $accountReference = null, $password = null, $limit = null, $currencyCode = null, $personID = null, $personName = null, $foreignCurrencyCode = null, $foreignAmount = null, \ArrayType\ArrayOfAccountCredit $accountCredits = null, $availableCredits = null, $spoiledCurrencyCode = null, $spoiledForeignAmount = null)
    {
        $this
            ->setAccountID($accountID)
            ->setAccountType($accountType)
            ->setAccountHolderType($accountHolderType)
            ->setStatus($status)
            ->setAccountReference($accountReference)
            ->setPassword($password)
            ->setLimit($limit)
            ->setCurrencyCode($currencyCode)
            ->setPersonID($personID)
            ->setPersonName($personName)
            ->setForeignCurrencyCode($foreignCurrencyCode)
            ->setForeignAmount($foreignAmount)
            ->setAccountCredits($accountCredits)
            ->setAvailableCredits($availableCredits)
            ->setSpoiledCurrencyCode($spoiledCurrencyCode)
            ->setSpoiledForeignAmount($spoiledForeignAmount);
    }
    /**
     * Get AccountID value
     * @return int|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \StructType\Account
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !(is_int($accountID) || ctype_digit($accountID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountID, true), gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @uses \EnumType\AccountType::valueIsValid()
     * @uses \EnumType\AccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \StructType\Account
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountType::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountType', is_array($accountType) ? implode(', ', $accountType) : var_export($accountType, true), implode(', ', \EnumType\AccountType::getValidValues())), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get AccountHolderType value
     * @return string|null
     */
    public function getAccountHolderType()
    {
        return $this->AccountHolderType;
    }
    /**
     * Set AccountHolderType value
     * @uses \EnumType\AccountHolderType::valueIsValid()
     * @uses \EnumType\AccountHolderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountHolderType
     * @return \StructType\Account
     */
    public function setAccountHolderType($accountHolderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountHolderType::valueIsValid($accountHolderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountHolderType', is_array($accountHolderType) ? implode(', ', $accountHolderType) : var_export($accountHolderType, true), implode(', ', \EnumType\AccountHolderType::getValidValues())), __LINE__);
        }
        $this->AccountHolderType = $accountHolderType;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\AccountStatus::valueIsValid()
     * @uses \EnumType\AccountStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Account
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\AccountStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get AccountReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountReference()
    {
        return isset($this->AccountReference) ? $this->AccountReference : null;
    }
    /**
     * Set AccountReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountReference
     * @return \StructType\Account
     */
    public function setAccountReference($accountReference = null)
    {
        // validation for constraint: string
        if (!is_null($accountReference) && !is_string($accountReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountReference, true), gettype($accountReference)), __LINE__);
        }
        if (is_null($accountReference) || (is_array($accountReference) && empty($accountReference))) {
            unset($this->AccountReference);
        } else {
            $this->AccountReference = $accountReference;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\Account
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Limit value
     * @return float|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param float $limit
     * @return \StructType\Account
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: float
        if (!is_null($limit) && !(is_float($limit) || is_numeric($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\Account
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get PersonID value
     * @return int|null
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \StructType\Account
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !(is_int($personID) || ctype_digit($personID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personID, true), gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get PersonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonName()
    {
        return isset($this->PersonName) ? $this->PersonName : null;
    }
    /**
     * Set PersonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personName
     * @return \StructType\Account
     */
    public function setPersonName($personName = null)
    {
        // validation for constraint: string
        if (!is_null($personName) && !is_string($personName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personName, true), gettype($personName)), __LINE__);
        }
        if (is_null($personName) || (is_array($personName) && empty($personName))) {
            unset($this->PersonName);
        } else {
            $this->PersonName = $personName;
        }
        return $this;
    }
    /**
     * Get ForeignCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForeignCurrencyCode()
    {
        return isset($this->ForeignCurrencyCode) ? $this->ForeignCurrencyCode : null;
    }
    /**
     * Set ForeignCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foreignCurrencyCode
     * @return \StructType\Account
     */
    public function setForeignCurrencyCode($foreignCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($foreignCurrencyCode) && !is_string($foreignCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foreignCurrencyCode, true), gettype($foreignCurrencyCode)), __LINE__);
        }
        if (is_null($foreignCurrencyCode) || (is_array($foreignCurrencyCode) && empty($foreignCurrencyCode))) {
            unset($this->ForeignCurrencyCode);
        } else {
            $this->ForeignCurrencyCode = $foreignCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ForeignAmount value
     * @return float|null
     */
    public function getForeignAmount()
    {
        return $this->ForeignAmount;
    }
    /**
     * Set ForeignAmount value
     * @param float $foreignAmount
     * @return \StructType\Account
     */
    public function setForeignAmount($foreignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($foreignAmount) && !(is_float($foreignAmount) || is_numeric($foreignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($foreignAmount, true), gettype($foreignAmount)), __LINE__);
        }
        $this->ForeignAmount = $foreignAmount;
        return $this;
    }
    /**
     * Get AccountCredits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAccountCredit|null
     */
    public function getAccountCredits()
    {
        return isset($this->AccountCredits) ? $this->AccountCredits : null;
    }
    /**
     * Set AccountCredits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAccountCredit $accountCredits
     * @return \StructType\Account
     */
    public function setAccountCredits(\ArrayType\ArrayOfAccountCredit $accountCredits = null)
    {
        if (is_null($accountCredits) || (is_array($accountCredits) && empty($accountCredits))) {
            unset($this->AccountCredits);
        } else {
            $this->AccountCredits = $accountCredits;
        }
        return $this;
    }
    /**
     * Get AvailableCredits value
     * @return float|null
     */
    public function getAvailableCredits()
    {
        return $this->AvailableCredits;
    }
    /**
     * Set AvailableCredits value
     * @param float $availableCredits
     * @return \StructType\Account
     */
    public function setAvailableCredits($availableCredits = null)
    {
        // validation for constraint: float
        if (!is_null($availableCredits) && !(is_float($availableCredits) || is_numeric($availableCredits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($availableCredits, true), gettype($availableCredits)), __LINE__);
        }
        $this->AvailableCredits = $availableCredits;
        return $this;
    }
    /**
     * Get SpoiledCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoiledCurrencyCode()
    {
        return isset($this->SpoiledCurrencyCode) ? $this->SpoiledCurrencyCode : null;
    }
    /**
     * Set SpoiledCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoiledCurrencyCode
     * @return \StructType\Account
     */
    public function setSpoiledCurrencyCode($spoiledCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($spoiledCurrencyCode) && !is_string($spoiledCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoiledCurrencyCode, true), gettype($spoiledCurrencyCode)), __LINE__);
        }
        if (is_null($spoiledCurrencyCode) || (is_array($spoiledCurrencyCode) && empty($spoiledCurrencyCode))) {
            unset($this->SpoiledCurrencyCode);
        } else {
            $this->SpoiledCurrencyCode = $spoiledCurrencyCode;
        }
        return $this;
    }
    /**
     * Get SpoiledForeignAmount value
     * @return float|null
     */
    public function getSpoiledForeignAmount()
    {
        return $this->SpoiledForeignAmount;
    }
    /**
     * Set SpoiledForeignAmount value
     * @param float $spoiledForeignAmount
     * @return \StructType\Account
     */
    public function setSpoiledForeignAmount($spoiledForeignAmount = null)
    {
        // validation for constraint: float
        if (!is_null($spoiledForeignAmount) && !(is_float($spoiledForeignAmount) || is_numeric($spoiledForeignAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($spoiledForeignAmount, true), gettype($spoiledForeignAmount)), __LINE__);
        }
        $this->SpoiledForeignAmount = $spoiledForeignAmount;
        return $this;
    }
}
