<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the ContractVersion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $contractVersion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContractVersion($contractVersion, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ContractVersion', $contractVersion, $mustUnderstand, $actor);
    }
    /**
     * Sets the EnableExceptionStackTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $enableExceptionStackTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEnableExceptionStackTrace($enableExceptionStackTrace, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EnableExceptionStackTrace', $enableExceptionStackTrace, $mustUnderstand, $actor);
    }
    /**
     * Sets the MessageContractVersion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $messageContractVersion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageContractVersion($messageContractVersion, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageContractVersion', $messageContractVersion, $mustUnderstand, $actor);
    }
    /**
     * Sets the Signature SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $signature
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSignature($signature, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Signature', $signature, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountRequest $parameters
     * @return \StructType\GetAccountResponse|bool
     */
    public function GetAccount(\StructType\GetAccountRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountByReference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountByReferenceRequest $parameters
     * @return \StructType\GetAccountByReferenceResponse|bool
     */
    public function GetAccountByReference(\StructType\GetAccountByReferenceRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAvailableCreditByReference
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAvailableCreditByReferenceRequest $parameters
     * @return \StructType\GetAvailableCreditByReferenceResponse|bool
     */
    public function GetAvailableCreditByReference(\StructType\GetAvailableCreditByReferenceRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAvailableCreditByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountByReferenceResponse|\StructType\GetAccountResponse|\StructType\GetAvailableCreditByReferenceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
