<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Commit ServiceType
 * @subpackage Services
 */
class Commit extends AbstractSoapClientBase
{
    /**
     * Sets the ContractVersion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $contractVersion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContractVersion($contractVersion, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ContractVersion', $contractVersion, $mustUnderstand, $actor);
    }
    /**
     * Sets the EnableExceptionStackTrace SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $enableExceptionStackTrace
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEnableExceptionStackTrace($enableExceptionStackTrace, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EnableExceptionStackTrace', $enableExceptionStackTrace, $mustUnderstand, $actor);
    }
    /**
     * Sets the MessageContractVersion SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $messageContractVersion
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageContractVersion($messageContractVersion, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageContractVersion', $messageContractVersion, $mustUnderstand, $actor);
    }
    /**
     * Sets the Signature SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param $signature
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSignature($signature, $nameSpace = 'http://schemas.navitaire.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Signature', $signature, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CommitAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CommitAccountRequest $parameters
     * @return \StructType\CommitAccountResponse|bool
     */
    public function CommitAccount(\StructType\CommitAccountRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CommitAccount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CommitAccountTransactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CommitAccountTransactionsRequest $parameters
     * @return \StructType\CommitAccountTransactionsResponse|bool
     */
    public function CommitAccountTransactions(\StructType\CommitAccountTransactionsRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CommitAccountTransactions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CommitAccountBatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CommitAccountBatchRequest $parameters
     * @return \StructType\CommitAccountBatchResponse|bool
     */
    public function CommitAccountBatch(\StructType\CommitAccountBatchRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CommitAccountBatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CommitAccountTransactionBatchEntry
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ContractVersion, EnableExceptionStackTrace, MessageContractVersion, Signature
     * - SOAPHeaderNamespaces: http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices, http://schemas.navitaire.com/WebServices
     * - SOAPHeaderTypes: int, boolean, string, string
     * - SOAPHeaders: required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CommitAccountTransactionsBatchRequest $parameters
     * @return \StructType\CommitAccountTransactionsBatchResponse|bool
     */
    public function CommitAccountTransactionBatchEntry(\StructType\CommitAccountTransactionsBatchRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CommitAccountTransactionBatchEntry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CommitAccountBatchResponse|\StructType\CommitAccountResponse|\StructType\CommitAccountTransactionsBatchResponse|\StructType\CommitAccountTransactionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
