<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MessageState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MessageState
 * @subpackage Enumerations
 */
class MessageState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Constant for value 'Clean'
     * @return string 'Clean'
     */
    const VALUE_CLEAN = 'Clean';
    /**
     * Constant for value 'Modified'
     * @return string 'Modified'
     */
    const VALUE_MODIFIED = 'Modified';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Unmapped'
     * @return string 'Unmapped'
     */
    const VALUE_UNMAPPED = 'Unmapped';
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_CLEAN
     * @uses self::VALUE_MODIFIED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_UNMAPPED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_CLEAN,
            self::VALUE_MODIFIED,
            self::VALUE_DELETED,
            self::VALUE_CONFIRMED,
            self::VALUE_UNMAPPED,
        );
    }
}
