<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfValidationResult ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfValidationResult
 * @subpackage Arrays
 */
class ArrayOfValidationResult extends AbstractStructArrayBase
{
    /**
     * The ValidationResult
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidationResult[]
     */
    public $ValidationResult;
    /**
     * Constructor method for ArrayOfValidationResult
     * @uses ArrayOfValidationResult::setValidationResult()
     * @param \StructType\ValidationResult[] $validationResult
     */
    public function __construct(array $validationResult = array())
    {
        $this
            ->setValidationResult($validationResult);
    }
    /**
     * Get ValidationResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidationResult[]|null
     */
    public function getValidationResult()
    {
        return isset($this->ValidationResult) ? $this->ValidationResult : null;
    }
    /**
     * This method is responsible for validating the values passed to the setValidationResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidationResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValidationResultForArrayConstraintsFromSetValidationResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfValidationResultValidationResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfValidationResultValidationResultItem instanceof \StructType\ValidationResult) {
                $invalidValues[] = is_object($arrayOfValidationResultValidationResultItem) ? get_class($arrayOfValidationResultValidationResultItem) : sprintf('%s(%s)', gettype($arrayOfValidationResultValidationResultItem), var_export($arrayOfValidationResultValidationResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValidationResult property can only contain items of type \StructType\ValidationResult, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValidationResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationResult[] $validationResult
     * @return \ArrayType\ArrayOfValidationResult
     */
    public function setValidationResult(array $validationResult = array())
    {
        // validation for constraint: array
        if ('' !== ($validationResultArrayErrorMessage = self::validateValidationResultForArrayConstraintsFromSetValidationResult($validationResult))) {
            throw new \InvalidArgumentException($validationResultArrayErrorMessage, __LINE__);
        }
        if (is_null($validationResult) || (is_array($validationResult) && empty($validationResult))) {
            unset($this->ValidationResult);
        } else {
            $this->ValidationResult = $validationResult;
        }
        return $this;
    }
    /**
     * Add item to ValidationResult value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationResult $item
     * @return \ArrayType\ArrayOfValidationResult
     */
    public function addToValidationResult(\StructType\ValidationResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidationResult) {
            throw new \InvalidArgumentException(sprintf('The ValidationResult property can only contain items of type \StructType\ValidationResult, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValidationResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ValidationResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ValidationResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ValidationResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ValidationResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ValidationResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ValidationResult
     */
    public function getAttributeName()
    {
        return 'ValidationResult';
    }
}
