<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateReturnRequestParams GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiUpdateReturnRequestParams extends AbstractStructBase
{
    /**
     * The nDaysValid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nDaysValid;
    /**
     * The bPayedBySender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bPayedBySender;
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The sReturnSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sReturnSerial;
    /**
     * The sRecipientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sRecipientId;
    /**
     * Constructor method for UpdateReturnRequestParams
     * @uses GenikiUpdateReturnRequestParams::setNDaysValid()
     * @uses GenikiUpdateReturnRequestParams::setBPayedBySender()
     * @uses GenikiUpdateReturnRequestParams::setSAuthKey()
     * @uses GenikiUpdateReturnRequestParams::setSReturnSerial()
     * @uses GenikiUpdateReturnRequestParams::setSRecipientId()
     * @param int $nDaysValid
     * @param bool $bPayedBySender
     * @param string $sAuthKey
     * @param string $sReturnSerial
     * @param string $sRecipientId
     */
    public function __construct($nDaysValid = null, $bPayedBySender = null, $sAuthKey = null, $sReturnSerial = null, $sRecipientId = null)
    {
        $this
            ->setNDaysValid($nDaysValid)
            ->setBPayedBySender($bPayedBySender)
            ->setSAuthKey($sAuthKey)
            ->setSReturnSerial($sReturnSerial)
            ->setSRecipientId($sRecipientId);
    }
    /**
     * Get nDaysValid value
     * @return int
     */
    public function getNDaysValid()
    {
        return $this->nDaysValid;
    }
    /**
     * Set nDaysValid value
     * @param int $nDaysValid
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParams
     */
    public function setNDaysValid($nDaysValid = null)
    {
        // validation for constraint: int
        if (!is_null($nDaysValid) && !(is_int($nDaysValid) || ctype_digit($nDaysValid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nDaysValid, true), gettype($nDaysValid)), __LINE__);
        }
        $this->nDaysValid = $nDaysValid;
        return $this;
    }
    /**
     * Get bPayedBySender value
     * @return bool
     */
    public function getBPayedBySender()
    {
        return $this->bPayedBySender;
    }
    /**
     * Set bPayedBySender value
     * @param bool $bPayedBySender
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParams
     */
    public function setBPayedBySender($bPayedBySender = null)
    {
        // validation for constraint: boolean
        if (!is_null($bPayedBySender) && !is_bool($bPayedBySender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bPayedBySender, true), gettype($bPayedBySender)), __LINE__);
        }
        $this->bPayedBySender = $bPayedBySender;
        return $this;
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParams
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get sReturnSerial value
     * @return string|null
     */
    public function getSReturnSerial()
    {
        return $this->sReturnSerial;
    }
    /**
     * Set sReturnSerial value
     * @param string $sReturnSerial
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParams
     */
    public function setSReturnSerial($sReturnSerial = null)
    {
        // validation for constraint: string
        if (!is_null($sReturnSerial) && !is_string($sReturnSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sReturnSerial, true), gettype($sReturnSerial)), __LINE__);
        }
        $this->sReturnSerial = $sReturnSerial;
        return $this;
    }
    /**
     * Get sRecipientId value
     * @return string|null
     */
    public function getSRecipientId()
    {
        return $this->sRecipientId;
    }
    /**
     * Set sRecipientId value
     * @param string $sRecipientId
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParams
     */
    public function setSRecipientId($sRecipientId = null)
    {
        // validation for constraint: string
        if (!is_null($sRecipientId) && !is_string($sRecipientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sRecipientId, true), gettype($sRecipientId)), __LINE__);
        }
        $this->sRecipientId = $sRecipientId;
        return $this;
    }
}
