<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetReturnRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetReturnRequest $parameters
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestResponse|bool
     */
    public function GetReturnRequest(\Geniki\GenikiStruct\GenikiGetReturnRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnRequestOfVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetReturnRequestOfVoucher $parameters
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestOfVoucherResponse|bool
     */
    public function GetReturnRequestOfVoucher(\Geniki\GenikiStruct\GenikiGetReturnRequestOfVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnRequestOfVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnRequestPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetReturnRequestPdf $parameters
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestPdfResponse|bool
     */
    public function GetReturnRequestPdf(\Geniki\GenikiStruct\GenikiGetReturnRequestPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnRequestPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetReturnRequestsPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetReturnRequestsPdf $parameters
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestsPdfResponse|bool
     */
    public function GetReturnRequestsPdf(\Geniki\GenikiStruct\GenikiGetReturnRequestsPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetReturnRequestsPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetVoucherJob $parameters
     * @return \Geniki\GenikiStruct\GenikiGetVoucherJobResponse|bool
     */
    public function GetVoucherJob(\Geniki\GenikiStruct\GenikiGetVoucherJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetJobsFromOrderId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetJobsFromOrderId $parameters
     * @return \Geniki\GenikiStruct\GenikiGetJobsFromOrderIdResponse|bool
     */
    public function GetJobsFromOrderId(\Geniki\GenikiStruct\GenikiGetJobsFromOrderId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetJobsFromOrderId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetJobs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetJobs $parameters
     * @return \Geniki\GenikiStruct\GenikiGetJobsResponse|bool
     */
    public function GetJobs(\Geniki\GenikiStruct\GenikiGetJobs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetVoucherPdf $parameters
     * @return \Geniki\GenikiStruct\GenikiGetVoucherPdfResponse|bool
     */
    public function GetVoucherPdf(\Geniki\GenikiStruct\GenikiGetVoucherPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetVouchersPdf $parameters
     * @return \Geniki\GenikiStruct\GenikiGetVouchersPdfResponse|bool
     */
    public function GetVouchersPdf(\Geniki\GenikiStruct\GenikiGetVouchersPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShopsList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiGetShopsList $parameters
     * @return \Geniki\GenikiStruct\GenikiGetShopsListResponse|bool
     */
    public function GetShopsList(\Geniki\GenikiStruct\GenikiGetShopsList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShopsList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiGetJobsFromOrderIdResponse|\Geniki\GenikiStruct\GenikiGetJobsResponse|\Geniki\GenikiStruct\GenikiGetReturnRequestOfVoucherResponse|\Geniki\GenikiStruct\GenikiGetReturnRequestPdfResponse|\Geniki\GenikiStruct\GenikiGetReturnRequestResponse|\Geniki\GenikiStruct\GenikiGetReturnRequestsPdfResponse|\Geniki\GenikiStruct\GenikiGetShopsListResponse|\Geniki\GenikiStruct\GenikiGetVoucherJobResponse|\Geniki\GenikiStruct\GenikiGetVoucherPdfResponse|\Geniki\GenikiStruct\GenikiGetVouchersPdfResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
