<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiChange extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ChangePassword
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiChangePassword $parameters
     * @return \Geniki\GenikiStruct\GenikiChangePasswordResponse|bool
     */
    public function ChangePassword(\Geniki\GenikiStruct\GenikiChangePassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangePassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiChangePasswordResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
