<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackDeliveryStatusResult GenikiStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TrackDeliveryStatusResult
 * @package Geniki
 * @subpackage Structs
 */
class GenikiTrackDeliveryStatusResult extends GenikiMethodResult
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ShopCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShopCode;
    /**
     * The Consignee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Consignee;
    /**
     * Constructor method for TrackDeliveryStatusResult
     * @uses GenikiTrackDeliveryStatusResult::setDeliveryDate()
     * @uses GenikiTrackDeliveryStatusResult::setStatus()
     * @uses GenikiTrackDeliveryStatusResult::setShopCode()
     * @uses GenikiTrackDeliveryStatusResult::setConsignee()
     * @param string $deliveryDate
     * @param string $status
     * @param string $shopCode
     * @param string $consignee
     */
    public function __construct($deliveryDate = null, $status = null, $shopCode = null, $consignee = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setStatus($status)
            ->setShopCode($shopCode)
            ->setConsignee($consignee);
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Geniki\GenikiStruct\GenikiTrackDeliveryStatusResult
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Geniki\GenikiStruct\GenikiTrackDeliveryStatusResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ShopCode value
     * @return string|null
     */
    public function getShopCode()
    {
        return $this->ShopCode;
    }
    /**
     * Set ShopCode value
     * @param string $shopCode
     * @return \Geniki\GenikiStruct\GenikiTrackDeliveryStatusResult
     */
    public function setShopCode($shopCode = null)
    {
        // validation for constraint: string
        if (!is_null($shopCode) && !is_string($shopCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shopCode, true), gettype($shopCode)), __LINE__);
        }
        $this->ShopCode = $shopCode;
        return $this;
    }
    /**
     * Get Consignee value
     * @return string|null
     */
    public function getConsignee()
    {
        return $this->Consignee;
    }
    /**
     * Set Consignee value
     * @param string $consignee
     * @return \Geniki\GenikiStruct\GenikiTrackDeliveryStatusResult
     */
    public function setConsignee($consignee = null)
    {
        // validation for constraint: string
        if (!is_null($consignee) && !is_string($consignee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignee, true), gettype($consignee)), __LINE__);
        }
        $this->Consignee = $consignee;
        return $this;
    }
}
