<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackAndTraceResult GenikiStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TrackAndTraceResult
 * @package Geniki
 * @subpackage Structs
 */
class GenikiTrackAndTraceResult extends GenikiMethodResult
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryDate;
    /**
     * The Checkpoints
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfCheckpoint
     */
    public $Checkpoints;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Consignee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Consignee;
    /**
     * Constructor method for TrackAndTraceResult
     * @uses GenikiTrackAndTraceResult::setDeliveryDate()
     * @uses GenikiTrackAndTraceResult::setCheckpoints()
     * @uses GenikiTrackAndTraceResult::setStatus()
     * @uses GenikiTrackAndTraceResult::setConsignee()
     * @param string $deliveryDate
     * @param \Geniki\GenikiArray\GenikiArrayOfCheckpoint $checkpoints
     * @param string $status
     * @param string $consignee
     */
    public function __construct($deliveryDate = null, \Geniki\GenikiArray\GenikiArrayOfCheckpoint $checkpoints = null, $status = null, $consignee = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setCheckpoints($checkpoints)
            ->setStatus($status)
            ->setConsignee($consignee);
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Geniki\GenikiStruct\GenikiTrackAndTraceResult
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get Checkpoints value
     * @return \Geniki\GenikiArray\GenikiArrayOfCheckpoint|null
     */
    public function getCheckpoints()
    {
        return $this->Checkpoints;
    }
    /**
     * Set Checkpoints value
     * @param \Geniki\GenikiArray\GenikiArrayOfCheckpoint $checkpoints
     * @return \Geniki\GenikiStruct\GenikiTrackAndTraceResult
     */
    public function setCheckpoints(\Geniki\GenikiArray\GenikiArrayOfCheckpoint $checkpoints = null)
    {
        $this->Checkpoints = $checkpoints;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Geniki\GenikiStruct\GenikiTrackAndTraceResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Consignee value
     * @return string|null
     */
    public function getConsignee()
    {
        return $this->Consignee;
    }
    /**
     * Set Consignee value
     * @param string $consignee
     * @return \Geniki\GenikiStruct\GenikiTrackAndTraceResult
     */
    public function setConsignee($consignee = null)
    {
        // validation for constraint: string
        if (!is_null($consignee) && !is_string($consignee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignee, true), gettype($consignee)), __LINE__);
        }
        $this->Consignee = $consignee;
        return $this;
    }
}
