<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherPdf GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetVoucherPdf extends AbstractStructBase
{
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $format;
    /**
     * The extraInfoFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $extraInfoFormat;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNo;
    /**
     * Constructor method for GetVoucherPdf
     * @uses GenikiGetVoucherPdf::setFormat()
     * @uses GenikiGetVoucherPdf::setExtraInfoFormat()
     * @uses GenikiGetVoucherPdf::setAuthKey()
     * @uses GenikiGetVoucherPdf::setVoucherNo()
     * @param string $format
     * @param string $extraInfoFormat
     * @param string $authKey
     * @param string $voucherNo
     */
    public function __construct($format = null, $extraInfoFormat = null, $authKey = null, $voucherNo = null)
    {
        $this
            ->setFormat($format)
            ->setExtraInfoFormat($extraInfoFormat)
            ->setAuthKey($authKey)
            ->setVoucherNo($voucherNo);
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Geniki\GenikiEnum\GenikiMediaFormat::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiMediaFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Geniki\GenikiStruct\GenikiGetVoucherPdf
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiMediaFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiMediaFormat', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \Geniki\GenikiEnum\GenikiMediaFormat::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get extraInfoFormat value
     * @return string
     */
    public function getExtraInfoFormat()
    {
        return $this->extraInfoFormat;
    }
    /**
     * Set extraInfoFormat value
     * @uses \Geniki\GenikiEnum\GenikiExtraInfoFormat::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiExtraInfoFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $extraInfoFormat
     * @return \Geniki\GenikiStruct\GenikiGetVoucherPdf
     */
    public function setExtraInfoFormat($extraInfoFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiExtraInfoFormat::valueIsValid($extraInfoFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiExtraInfoFormat', is_array($extraInfoFormat) ? implode(', ', $extraInfoFormat) : var_export($extraInfoFormat, true), implode(', ', \Geniki\GenikiEnum\GenikiExtraInfoFormat::getValidValues())), __LINE__);
        }
        $this->extraInfoFormat = $extraInfoFormat;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetVoucherPdf
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNo value
     * @return string|null
     */
    public function getVoucherNo()
    {
        return $this->voucherNo;
    }
    /**
     * Set voucherNo value
     * @param string $voucherNo
     * @return \Geniki\GenikiStruct\GenikiGetVoucherPdf
     */
    public function setVoucherNo($voucherNo = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNo) && !is_string($voucherNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNo, true), gettype($voucherNo)), __LINE__);
        }
        $this->voucherNo = $voucherNo;
        return $this;
    }
}
