<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateReturnRequest GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateReturnRequest extends AbstractStructBase
{
    /**
     * The nDaysValid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nDaysValid;
    /**
     * The bPayedBySender
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bPayedBySender;
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The oReturnRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiStruct\GenikiReturnRecord
     */
    public $oReturnRecord;
    /**
     * The sRecipientId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sRecipientId;
    /**
     * Constructor method for CreateReturnRequest
     * @uses GenikiCreateReturnRequest::setNDaysValid()
     * @uses GenikiCreateReturnRequest::setBPayedBySender()
     * @uses GenikiCreateReturnRequest::setSAuthKey()
     * @uses GenikiCreateReturnRequest::setOReturnRecord()
     * @uses GenikiCreateReturnRequest::setSRecipientId()
     * @param int $nDaysValid
     * @param bool $bPayedBySender
     * @param string $sAuthKey
     * @param \Geniki\GenikiStruct\GenikiReturnRecord $oReturnRecord
     * @param string $sRecipientId
     */
    public function __construct($nDaysValid = null, $bPayedBySender = null, $sAuthKey = null, \Geniki\GenikiStruct\GenikiReturnRecord $oReturnRecord = null, $sRecipientId = null)
    {
        $this
            ->setNDaysValid($nDaysValid)
            ->setBPayedBySender($bPayedBySender)
            ->setSAuthKey($sAuthKey)
            ->setOReturnRecord($oReturnRecord)
            ->setSRecipientId($sRecipientId);
    }
    /**
     * Get nDaysValid value
     * @return int
     */
    public function getNDaysValid()
    {
        return $this->nDaysValid;
    }
    /**
     * Set nDaysValid value
     * @param int $nDaysValid
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequest
     */
    public function setNDaysValid($nDaysValid = null)
    {
        // validation for constraint: int
        if (!is_null($nDaysValid) && !(is_int($nDaysValid) || ctype_digit($nDaysValid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nDaysValid, true), gettype($nDaysValid)), __LINE__);
        }
        $this->nDaysValid = $nDaysValid;
        return $this;
    }
    /**
     * Get bPayedBySender value
     * @return bool
     */
    public function getBPayedBySender()
    {
        return $this->bPayedBySender;
    }
    /**
     * Set bPayedBySender value
     * @param bool $bPayedBySender
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequest
     */
    public function setBPayedBySender($bPayedBySender = null)
    {
        // validation for constraint: boolean
        if (!is_null($bPayedBySender) && !is_bool($bPayedBySender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bPayedBySender, true), gettype($bPayedBySender)), __LINE__);
        }
        $this->bPayedBySender = $bPayedBySender;
        return $this;
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequest
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get oReturnRecord value
     * @return \Geniki\GenikiStruct\GenikiReturnRecord|null
     */
    public function getOReturnRecord()
    {
        return $this->oReturnRecord;
    }
    /**
     * Set oReturnRecord value
     * @param \Geniki\GenikiStruct\GenikiReturnRecord $oReturnRecord
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequest
     */
    public function setOReturnRecord(\Geniki\GenikiStruct\GenikiReturnRecord $oReturnRecord = null)
    {
        $this->oReturnRecord = $oReturnRecord;
        return $this;
    }
    /**
     * Get sRecipientId value
     * @return string|null
     */
    public function getSRecipientId()
    {
        return $this->sRecipientId;
    }
    /**
     * Set sRecipientId value
     * @param string $sRecipientId
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequest
     */
    public function setSRecipientId($sRecipientId = null)
    {
        // validation for constraint: string
        if (!is_null($sRecipientId) && !is_string($sRecipientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sRecipientId, true), gettype($sRecipientId)), __LINE__);
        }
        $this->sRecipientId = $sRecipientId;
        return $this;
    }
}
