<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateReturnRequestParams
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiUpdateReturnRequestParams $parameters
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParamsResponse|bool
     */
    public function UpdateReturnRequestParams(\Geniki\GenikiStruct\GenikiUpdateReturnRequestParams $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateReturnRequestParams($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiUpdateReturnRequestParamsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
