<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiCreate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreateClientVoucherJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateClientVoucherJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateClientVoucherJobResponse|bool
     */
    public function CreateClientVoucherJob(\Geniki\GenikiStruct\GenikiCreateClientVoucherJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateClientVoucherJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateGroupedVoucherJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateGroupedVoucherJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateGroupedVoucherJobResponse|bool
     */
    public function CreateGroupedVoucherJob(\Geniki\GenikiStruct\GenikiCreateGroupedVoucherJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateGroupedVoucherJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateReturnRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateReturnRequest $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateReturnRequestResponse|bool
     */
    public function CreateReturnRequest(\Geniki\GenikiStruct\GenikiCreateReturnRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateReturnRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVoucherReturnRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateVoucherReturnRequest $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherReturnRequestResponse|bool
     */
    public function CreateVoucherReturnRequest(\Geniki\GenikiStruct\GenikiCreateVoucherReturnRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVoucherReturnRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCreateJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCreateJobResponse|bool
     */
    public function CreateJob(\Geniki\GenikiStruct\GenikiCreateJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiCreateClientVoucherJobResponse|\Geniki\GenikiStruct\GenikiCreateGroupedVoucherJobResponse|\Geniki\GenikiStruct\GenikiCreateJobResponse|\Geniki\GenikiStruct\GenikiCreateReturnRequestResponse|\Geniki\GenikiStruct\GenikiCreateVoucherReturnRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
