<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiCancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCancelJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCancelJobResponse|bool
     */
    public function CancelJob(\Geniki\GenikiStruct\GenikiCancelJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelAndCloseJob
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCancelAndCloseJob $parameters
     * @return \Geniki\GenikiStruct\GenikiCancelAndCloseJobResponse|bool
     */
    public function CancelAndCloseJob(\Geniki\GenikiStruct\GenikiCancelAndCloseJob $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelAndCloseJob($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiCancelAndCloseJobResponse|\Geniki\GenikiStruct\GenikiCancelJobResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
