<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReturnRequestPdf GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetReturnRequestPdf extends AbstractStructBase
{
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The returnSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnSerial;
    /**
     * Constructor method for GetReturnRequestPdf
     * @uses GenikiGetReturnRequestPdf::setAuthKey()
     * @uses GenikiGetReturnRequestPdf::setReturnSerial()
     * @param string $authKey
     * @param string $returnSerial
     */
    public function __construct($authKey = null, $returnSerial = null)
    {
        $this
            ->setAuthKey($authKey)
            ->setReturnSerial($returnSerial);
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestPdf
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get returnSerial value
     * @return string|null
     */
    public function getReturnSerial()
    {
        return $this->returnSerial;
    }
    /**
     * Set returnSerial value
     * @param string $returnSerial
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestPdf
     */
    public function setReturnSerial($returnSerial = null)
    {
        // validation for constraint: string
        if (!is_null($returnSerial) && !is_string($returnSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnSerial, true), gettype($returnSerial)), __LINE__);
        }
        $this->returnSerial = $returnSerial;
        return $this;
    }
}
