<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dhlindiaplugin.com/DHLWCFService_V6/DHLService.svc?singleWsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://dhlindiaplugin.com/DHLWCFService_V6/DHLService.svc?singleWsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \DHL\DHLClassMap::get(),
);
/**
 * Samples for Post ServiceType
 */
$post = new \DHL\ServiceType\DHLPost($options);
/**
 * Sample call for PostQuotePos operation/method
 */
if ($post->PostQuotePos(new \DHL\StructType\DHLPostQuotePos()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostQuotePos_V6 operation/method
 */
if ($post->PostQuotePos_V6(new \DHL\StructType\DHLPostQuotePos_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostQuote_RAS operation/method
 */
if ($post->PostQuote_RAS(new \DHL\StructType\DHLPostQuote_RAS()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostQuote operation/method
 */
if ($post->PostQuote(new \DHL\StructType\DHLPostQuote()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostCapability operation/method
 */
if ($post->PostCapability(new \DHL\StructType\DHLPostCapability()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostPickup operation/method
 */
if ($post->PostPickup(new \DHL\StructType\DHLPostPickup()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostPickup_v6 operation/method
 */
if ($post->PostPickup_v6(new \DHL\StructType\DHLPostPickup_v6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService3C_V6 operation/method
 */
if ($post->PostShipmentWithSpecialService3C_V6(new \DHL\StructType\DHLPostShipmentWithSpecialService3C_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipment3C_V6 operation/method
 */
if ($post->PostShipment3C_V6(new \DHL\StructType\DHLPostShipment3C_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipment_V6 operation/method
 */
if ($post->PostShipment_V6(new \DHL\StructType\DHLPostShipment_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipment3CMPML_V6 operation/method
 */
if ($post->PostShipment3CMPML_V6(new \DHL\StructType\DHLPostShipment3CMPML_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostTracking operation/method
 */
if ($post->PostTracking(new \DHL\StructType\DHLPostTracking()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostTrackingReference operation/method
 */
if ($post->PostTrackingReference(new \DHL\StructType\DHLPostTrackingReference()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService3C operation/method
 */
if ($post->PostShipmentWithSpecialService3C(new \DHL\StructType\DHLPostShipmentWithSpecialService3C()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipment operation/method
 */
if ($post->PostShipment(new \DHL\StructType\DHLPostShipment()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipment3C operation/method
 */
if ($post->PostShipment3C(new \DHL\StructType\DHLPostShipment3C()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentwithCash_V6 operation/method
 */
if ($post->PostShipmentwithCash_V6(new \DHL\StructType\DHLPostShipmentwithCash_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentCSB2_V6 operation/method
 */
if ($post->PostShipmentCSB2_V6(new \DHL\StructType\DHLPostShipmentCSB2_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentCashwithSpecialService_v6 operation/method
 */
if ($post->PostShipmentCashwithSpecialService_v6(new \DHL\StructType\DHLPostShipmentCashwithSpecialService_v6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentCashwithSpecialService operation/method
 */
if ($post->PostShipmentCashwithSpecialService(new \DHL\StructType\DHLPostShipmentCashwithSpecialService()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialServiceCSB2_INS operation/method
 */
if ($post->PostShipmentWithSpecialServiceCSB2_INS(new \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_INS()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService_INS operation/method
 */
if ($post->PostShipmentWithSpecialService_INS(new \DHL\StructType\DHLPostShipmentWithSpecialService_INS()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService3CMPML operation/method
 */
if ($post->PostShipmentWithSpecialService3CMPML(new \DHL\StructType\DHLPostShipmentWithSpecialService3CMPML()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService3CMPML_V6 operation/method
 */
if ($post->PostShipmentWithSpecialService3CMPML_V6(new \DHL\StructType\DHLPostShipmentWithSpecialService3CMPML_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipment3CMPML operation/method
 */
if ($post->PostShipment3CMPML(new \DHL\StructType\DHLPostShipment3CMPML()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentCSB2 operation/method
 */
if ($post->PostShipmentCSB2(new \DHL\StructType\DHLPostShipmentCSB2()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService operation/method
 */
if ($post->PostShipmentWithSpecialService(new \DHL\StructType\DHLPostShipmentWithSpecialService()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialServiceCSB2 operation/method
 */
if ($post->PostShipmentWithSpecialServiceCSB2(new \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialServiceCSB2_V6 operation/method
 */
if ($post->PostShipmentWithSpecialServiceCSB2_V6(new \DHL\StructType\DHLPostShipmentWithSpecialServiceCSB2_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentwithCash operation/method
 */
if ($post->PostShipmentwithCash(new \DHL\StructType\DHLPostShipmentwithCash()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentCashwithSpecialServiceCSB5_v6 operation/method
 */
if ($post->PostShipmentCashwithSpecialServiceCSB5_v6(new \DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5_v6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostTracking_AllCheckpoint operation/method
 */
if ($post->PostTracking_AllCheckpoint(new \DHL\StructType\DHLPostTracking_AllCheckpoint()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostTrackingReference_AllCheckpoint operation/method
 */
if ($post->PostTrackingReference_AllCheckpoint(new \DHL\StructType\DHLPostTrackingReference_AllCheckpoint()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialServiceSCC_V6 operation/method
 */
if ($post->PostShipmentWithSpecialServiceSCC_V6(new \DHL\StructType\DHLPostShipmentWithSpecialServiceSCC_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentCashwithSpecialServiceCSB5New_v6 operation/method
 */
if ($post->PostShipmentCashwithSpecialServiceCSB5New_v6(new \DHL\StructType\DHLPostShipmentCashwithSpecialServiceCSB5New_v6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Sample call for PostShipmentWithSpecialService3CMPMLNew_V6 operation/method
 */
if ($post->PostShipmentWithSpecialService3CMPMLNew_V6(new \DHL\StructType\DHLPostShipmentWithSpecialService3CMPMLNew_V6()) !== false) {
    print_r($post->getResult());
} else {
    print_r($post->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \DHL\ServiceType\DHLGet($options);
/**
 * Sample call for GetIndemnityClause operation/method
 */
if ($get->GetIndemnityClause(new \DHL\StructType\DHLGetIndemnityClause()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
