<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostTrackingReferenceResponse StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostTrackingReferenceResponse extends AbstractStructBase
{
    /**
     * The PostTrackingReferenceResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostTrackingReferenceResult;
    /**
     * Constructor method for PostTrackingReferenceResponse
     * @uses DHLPostTrackingReferenceResponse::setPostTrackingReferenceResult()
     * @param string $postTrackingReferenceResult
     */
    public function __construct($postTrackingReferenceResult = null)
    {
        $this
            ->setPostTrackingReferenceResult($postTrackingReferenceResult);
    }
    /**
     * Get PostTrackingReferenceResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostTrackingReferenceResult()
    {
        return isset($this->PostTrackingReferenceResult) ? $this->PostTrackingReferenceResult : null;
    }
    /**
     * Set PostTrackingReferenceResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postTrackingReferenceResult
     * @return \DHL\StructType\DHLPostTrackingReferenceResponse
     */
    public function setPostTrackingReferenceResult($postTrackingReferenceResult = null)
    {
        // validation for constraint: string
        if (!is_null($postTrackingReferenceResult) && !is_string($postTrackingReferenceResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postTrackingReferenceResult, true), gettype($postTrackingReferenceResult)), __LINE__);
        }
        if (is_null($postTrackingReferenceResult) || (is_array($postTrackingReferenceResult) && empty($postTrackingReferenceResult))) {
            unset($this->PostTrackingReferenceResult);
        } else {
            $this->PostTrackingReferenceResult = $postTrackingReferenceResult;
        }
        return $this;
    }
}
