<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostTrackingReference StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostTrackingReference extends AbstractStructBase
{
    /**
     * The ShipperAccno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipperAccno;
    /**
     * The ReferenceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceID;
    /**
     * The ShipmentDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentDateFrom;
    /**
     * The ShipmentDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShipmentDateTo;
    /**
     * Constructor method for PostTrackingReference
     * @uses DHLPostTrackingReference::setShipperAccno()
     * @uses DHLPostTrackingReference::setReferenceID()
     * @uses DHLPostTrackingReference::setShipmentDateFrom()
     * @uses DHLPostTrackingReference::setShipmentDateTo()
     * @param string $shipperAccno
     * @param string $referenceID
     * @param string $shipmentDateFrom
     * @param string $shipmentDateTo
     */
    public function __construct($shipperAccno = null, $referenceID = null, $shipmentDateFrom = null, $shipmentDateTo = null)
    {
        $this
            ->setShipperAccno($shipperAccno)
            ->setReferenceID($referenceID)
            ->setShipmentDateFrom($shipmentDateFrom)
            ->setShipmentDateTo($shipmentDateTo);
    }
    /**
     * Get ShipperAccno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipperAccno()
    {
        return isset($this->ShipperAccno) ? $this->ShipperAccno : null;
    }
    /**
     * Set ShipperAccno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipperAccno
     * @return \DHL\StructType\DHLPostTrackingReference
     */
    public function setShipperAccno($shipperAccno = null)
    {
        // validation for constraint: string
        if (!is_null($shipperAccno) && !is_string($shipperAccno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipperAccno, true), gettype($shipperAccno)), __LINE__);
        }
        if (is_null($shipperAccno) || (is_array($shipperAccno) && empty($shipperAccno))) {
            unset($this->ShipperAccno);
        } else {
            $this->ShipperAccno = $shipperAccno;
        }
        return $this;
    }
    /**
     * Get ReferenceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceID()
    {
        return isset($this->ReferenceID) ? $this->ReferenceID : null;
    }
    /**
     * Set ReferenceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceID
     * @return \DHL\StructType\DHLPostTrackingReference
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceID, true), gettype($referenceID)), __LINE__);
        }
        if (is_null($referenceID) || (is_array($referenceID) && empty($referenceID))) {
            unset($this->ReferenceID);
        } else {
            $this->ReferenceID = $referenceID;
        }
        return $this;
    }
    /**
     * Get ShipmentDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentDateFrom()
    {
        return isset($this->ShipmentDateFrom) ? $this->ShipmentDateFrom : null;
    }
    /**
     * Set ShipmentDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentDateFrom
     * @return \DHL\StructType\DHLPostTrackingReference
     */
    public function setShipmentDateFrom($shipmentDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDateFrom) && !is_string($shipmentDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDateFrom, true), gettype($shipmentDateFrom)), __LINE__);
        }
        if (is_null($shipmentDateFrom) || (is_array($shipmentDateFrom) && empty($shipmentDateFrom))) {
            unset($this->ShipmentDateFrom);
        } else {
            $this->ShipmentDateFrom = $shipmentDateFrom;
        }
        return $this;
    }
    /**
     * Get ShipmentDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShipmentDateTo()
    {
        return isset($this->ShipmentDateTo) ? $this->ShipmentDateTo : null;
    }
    /**
     * Set ShipmentDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shipmentDateTo
     * @return \DHL\StructType\DHLPostTrackingReference
     */
    public function setShipmentDateTo($shipmentDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentDateTo) && !is_string($shipmentDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentDateTo, true), gettype($shipmentDateTo)), __LINE__);
        }
        if (is_null($shipmentDateTo) || (is_array($shipmentDateTo) && empty($shipmentDateTo))) {
            unset($this->ShipmentDateTo);
        } else {
            $this->ShipmentDateTo = $shipmentDateTo;
        }
        return $this;
    }
}
