<?php

namespace DHL\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostShipmentResponse StructType
 * @package DHL
 * @subpackage Structs
 */
class DHLPostShipmentResponse extends AbstractStructBase
{
    /**
     * The PostShipmentResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostShipmentResult;
    /**
     * Constructor method for PostShipmentResponse
     * @uses DHLPostShipmentResponse::setPostShipmentResult()
     * @param string $postShipmentResult
     */
    public function __construct($postShipmentResult = null)
    {
        $this
            ->setPostShipmentResult($postShipmentResult);
    }
    /**
     * Get PostShipmentResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostShipmentResult()
    {
        return isset($this->PostShipmentResult) ? $this->PostShipmentResult : null;
    }
    /**
     * Set PostShipmentResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postShipmentResult
     * @return \DHL\StructType\DHLPostShipmentResponse
     */
    public function setPostShipmentResult($postShipmentResult = null)
    {
        // validation for constraint: string
        if (!is_null($postShipmentResult) && !is_string($postShipmentResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postShipmentResult, true), gettype($postShipmentResult)), __LINE__);
        }
        if (is_null($postShipmentResult) || (is_array($postShipmentResult) && empty($postShipmentResult))) {
            unset($this->PostShipmentResult);
        } else {
            $this->PostShipmentResult = $postShipmentResult;
        }
        return $this;
    }
}
